"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToken = useToken;
exports.withToken = withToken;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _RootClose = require("../components/RootClose");
var _utils = require("../utils");
var _propTypes2 = require("../propTypes");
var _excluded = ["onBlur", "onClick", "onFocus", "onRemove", "option"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { "default": e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n["default"] = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2["default"])(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var propTypes = {
  onBlur: _propTypes["default"].func,
  onClick: _propTypes["default"].func,
  onFocus: _propTypes["default"].func,
  onRemove: _propTypes["default"].func,
  option: _propTypes2.optionType.isRequired
};
function useToken(_ref) {
  var onBlur = _ref.onBlur,
    onClick = _ref.onClick,
    onFocus = _ref.onFocus,
    onRemove = _ref.onRemove,
    option = _ref.option,
    props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var _useState = (0, _react.useState)(false),
    _useState2 = (0, _slicedToArray2["default"])(_useState, 2),
    active = _useState2[0],
    setActive = _useState2[1];
  var handleBlur = function handleBlur(e) {
    setActive(false);
    onBlur && onBlur(e);
  };
  var handleClick = function handleClick(e) {
    setActive(true);
    onClick && onClick(e);
  };
  var handleFocus = function handleFocus(e) {
    setActive(true);
    onFocus && onFocus(e);
  };
  var handleRemove = function handleRemove() {
    onRemove && onRemove(option);
  };
  var handleKeyDown = function handleKeyDown(e) {
    if (e.key === 'Backspace' && active) {
      // Prevent browser from going back.
      e.preventDefault();
      handleRemove();
    }
  };
  var attachRef = (0, _RootClose.useRootClose)(handleBlur, _objectSpread(_objectSpread({}, props), {}, {
    disabled: !active
  }));
  return {
    active: active,
    onBlur: handleBlur,
    onClick: handleClick,
    onFocus: handleFocus,
    onKeyDown: handleKeyDown,
    onRemove: (0, _utils.isFunction)(onRemove) ? handleRemove : undefined,
    ref: attachRef
  };
}

/* istanbul ignore next */
function withToken(Component) {
  (0, _utils.warn)(false, 'Warning: `withToken` is deprecated and will be removed in the next ' + 'major version. Use `useToken` instead.');
  var displayName = "withToken(".concat((0, _utils.getDisplayName)(Component), ")");
  var WrappedToken = function WrappedToken(props) {
    return /*#__PURE__*/_react["default"].createElement(Component, (0, _extends2["default"])({}, props, useToken(props)));
  };
  WrappedToken.displayName = displayName;
  WrappedToken.propTypes = propTypes;
  return WrappedToken;
}