import PropTypes from 'prop-types';
import React, { HTMLProps, ReactNode, Ref } from 'react';
export interface MenuProps extends HTMLProps<HTMLDivElement> {
    emptyLabel?: ReactNode;
    innerRef?: Ref<HTMLDivElement>;
    maxHeight?: string;
}
declare const Menu: {
    ({ emptyLabel, innerRef, maxHeight, style, ...props }: MenuProps): React.JSX.Element;
    propTypes: {
        'aria-label': PropTypes.Requireable<string>;
        emptyLabel: PropTypes.Requireable<PropTypes.ReactNodeLike>;
        id: (props: import("../../types").TypeaheadProps, propName: keyof import("../../types").TypeaheadProps, componentName: string) => void;
        maxHeight: PropTypes.Requireable<string>;
    };
    Divider: () => React.JSX.Element;
    Header: (props: HTMLProps<HTMLDivElement>) => React.JSX.Element;
};
export default Menu;
