import PropTypes from 'prop-types';
import React from 'react';
import { getMatchBounds } from '../../utils';
var propTypes = {
  children: PropTypes.string.isRequired,
  highlightClassName: PropTypes.string,
  search: PropTypes.string.isRequired
};
/**
 * Stripped-down version of https://github.com/helior/react-highlighter
 *
 * Results are already filtered by the time the component is used internally so
 * we can safely ignore case and diacritical marks for the purposes of matching.
 */
var Highlighter = function Highlighter(_ref) {
  var children = _ref.children,
    _ref$highlightClassNa = _ref.highlightClassName,
    highlightClassName = _ref$highlightClassNa === void 0 ? 'rbt-highlight-text' : _ref$highlightClassNa,
    search = _ref.search;
  if (!search || !children) {
    return /*#__PURE__*/React.createElement(React.Fragment, null, children);
  }
  var matchCount = 0;
  var remaining = children;
  var highlighterChildren = [];
  while (remaining) {
    var bounds = getMatchBounds(remaining, search);

    // No match anywhere in the remaining string, stop.
    if (!bounds) {
      highlighterChildren.push(remaining);
      break;
    }

    // Capture the string that leads up to a match.
    var nonMatch = remaining.slice(0, bounds.start);
    if (nonMatch) {
      highlighterChildren.push(nonMatch);
    }

    // Capture the matching string.
    var match = remaining.slice(bounds.start, bounds.end);
    highlighterChildren.push( /*#__PURE__*/React.createElement("mark", {
      className: highlightClassName,
      key: matchCount
    }, match));
    matchCount += 1;

    // And if there's anything left over, continue the loop.
    remaining = remaining.slice(bounds.end);
  }
  return /*#__PURE__*/React.createElement(React.Fragment, null, highlighterChildren);
};
Highlighter.propTypes = propTypes;
export default Highlighter;