import type { ReactNode } from "react";
import type { CSSObject } from "./types";
import type { EmotionCache } from "@emotion/cache";
import type { MuiThemeStyleOverridesPluginParams } from "./mui/themeStyleOverridesPlugin";
export declare function createMakeStyles<Theme>(params: {
    useTheme: () => Theme;
    cache?: EmotionCache;
}): {
    makeStyles: <Params = void, RuleNameSubsetReferencableInNestedSelectors extends string = never>(params?: {
        name?: string | Record<string, unknown> | undefined;
        uniqId?: string | undefined;
    } | undefined) => <RuleName extends string>(cssObjectByRuleNameOrGetCssObjectByRuleName: Record<RuleName, CSSObject> | ((theme: Theme, params: Params, classes: Record<RuleNameSubsetReferencableInNestedSelectors, string>) => Record<RuleNameSubsetReferencableInNestedSelectors | RuleName, CSSObject>)) => (params: Params, muiStyleOverridesParams?: MuiThemeStyleOverridesPluginParams["muiStyleOverridesParams"]) => {
        classes: Record<RuleName, string>;
        theme: Theme;
        css: import("./types").Css;
        cx: import("./types").Cx;
    };
    useStyles: () => {
        theme: Theme;
        css: import("./types").Css;
        cx: import("./types").Cx;
    };
};
export declare function TssCacheProvider(props: {
    value: EmotionCache;
    children: ReactNode;
}): import("react").ReactElement<any, any>;
export declare const createUseCache: (params: {
    cacheProvidedAtInception?: EmotionCache;
}) => {
    useCache: () => EmotionCache;
};
