import PropTypes from 'prop-types';
import useOverlay from './useOverlay';
import { ALIGN_VALUES } from '../../constants';
import { noop } from '../../utils';
const SafeElement = typeof Element === 'undefined' ? noop : Element;
const propTypes = {
    align: PropTypes.oneOf(ALIGN_VALUES),
    children: PropTypes.func.isRequired,
    dropup: PropTypes.bool,
    flip: PropTypes.bool,
    isMenuShown: PropTypes.bool,
    positionFixed: PropTypes.bool,
    referenceElement: PropTypes.instanceOf(SafeElement),
};
const Overlay = ({ referenceElement, isMenuShown, ...props }) => {
    const overlayProps = useOverlay(referenceElement, props);
    if (!isMenuShown) {
        return null;
    }
    return props.children(overlayProps);
};
Overlay.propTypes = propTypes;
export default Overlay;
