import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { isSizeLarge, isSizeSmall } from '../../utils';
import { sizeType } from '../../propTypes';
const propTypes = {
    label: PropTypes.string,
    onClick: PropTypes.func,
    onKeyDown: PropTypes.func,
    size: sizeType,
};
const ClearButton = ({ className, label = 'Clear', onClick, onKeyDown, size, ...props }) => (React.createElement("button", { ...props, "aria-label": label, className: cx('close', 'btn-close', 'rbt-close', {
        'rbt-close-lg': isSizeLarge(size),
        'rbt-close-sm': isSizeSmall(size),
    }, className), onClick: (e) => {
        e.stopPropagation();
        onClick && onClick(e);
    }, onKeyDown: (e) => {
        if (e.key === 'Backspace') {
            e.preventDefault();
        }
        onKeyDown && onKeyDown(e);
    }, type: "button" },
    React.createElement("span", { "aria-hidden": "true", className: "rbt-close-content" }, "\u00D7"),
    React.createElement("span", { className: "sr-only visually-hidden" }, label)));
ClearButton.propTypes = propTypes;
export default ClearButton;
