import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["onBlur", "onClick", "onFocus", "onRemove", "option"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import PropTypes from 'prop-types';
import React, { useState } from 'react';
import { useRootClose } from '../components/RootClose';
import { getDisplayName, isFunction, warn } from '../utils';
import { optionType } from '../propTypes';
var propTypes = {
  onBlur: PropTypes.func,
  onClick: PropTypes.func,
  onFocus: PropTypes.func,
  onRemove: PropTypes.func,
  option: optionType.isRequired
};
export function useToken(_ref) {
  var onBlur = _ref.onBlur,
    onClick = _ref.onClick,
    onFocus = _ref.onFocus,
    onRemove = _ref.onRemove,
    option = _ref.option,
    props = _objectWithoutProperties(_ref, _excluded);
  var _useState = useState(false),
    _useState2 = _slicedToArray(_useState, 2),
    active = _useState2[0],
    setActive = _useState2[1];
  var handleBlur = function handleBlur(e) {
    setActive(false);
    onBlur && onBlur(e);
  };
  var handleClick = function handleClick(e) {
    setActive(true);
    onClick && onClick(e);
  };
  var handleFocus = function handleFocus(e) {
    setActive(true);
    onFocus && onFocus(e);
  };
  var handleRemove = function handleRemove() {
    onRemove && onRemove(option);
  };
  var handleKeyDown = function handleKeyDown(e) {
    if (e.key === 'Backspace' && active) {
      // Prevent browser from going back.
      e.preventDefault();
      handleRemove();
    }
  };
  var attachRef = useRootClose(handleBlur, _objectSpread(_objectSpread({}, props), {}, {
    disabled: !active
  }));
  return {
    active: active,
    onBlur: handleBlur,
    onClick: handleClick,
    onFocus: handleFocus,
    onKeyDown: handleKeyDown,
    onRemove: isFunction(onRemove) ? handleRemove : undefined,
    ref: attachRef
  };
}

/* istanbul ignore next */
export function withToken(Component) {
  warn(false, 'Warning: `withToken` is deprecated and will be removed in the next ' + 'major version. Use `useToken` instead.');
  var displayName = "withToken(".concat(getDisplayName(Component), ")");
  var WrappedToken = function WrappedToken(props) {
    return /*#__PURE__*/React.createElement(Component, _extends({}, props, useToken(props)));
  };
  WrappedToken.displayName = displayName;
  WrappedToken.propTypes = propTypes;
  return WrappedToken;
}