"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useItem = useItem;
exports.withItem = withItem;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _scrollIntoViewIfNeeded = _interopRequireDefault(require("scroll-into-view-if-needed"));
var _Context = require("../core/Context");
var _utils = require("../utils");
var _propTypes2 = require("../propTypes");
var _excluded = ["label", "onClick", "option", "position"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { "default": e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n["default"] = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2["default"])(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var propTypes = {
  option: _propTypes2.optionType.isRequired,
  position: _propTypes["default"].number
};
function useItem(_ref) {
  var label = _ref.label,
    onClick = _ref.onClick,
    option = _ref.option,
    position = _ref.position,
    props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var _useTypeaheadContext = (0, _Context.useTypeaheadContext)(),
    activeIndex = _useTypeaheadContext.activeIndex,
    id = _useTypeaheadContext.id,
    isOnlyResult = _useTypeaheadContext.isOnlyResult,
    onActiveItemChange = _useTypeaheadContext.onActiveItemChange,
    onInitialItemChange = _useTypeaheadContext.onInitialItemChange,
    onMenuItemClick = _useTypeaheadContext.onMenuItemClick,
    setItem = _useTypeaheadContext.setItem;
  var itemRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(function () {
    if (position === 0) {
      onInitialItemChange(option);
    }
  });
  (0, _react.useEffect)(function () {
    if (position === activeIndex) {
      onActiveItemChange(option);

      // Automatically scroll the menu as the user keys through it.
      var node = itemRef.current;
      node && (0, _scrollIntoViewIfNeeded["default"])(node, {
        boundary: node.parentNode,
        scrollMode: 'if-needed'
      });
    }
  }, [activeIndex, onActiveItemChange, option, position]);
  var handleClick = (0, _react.useCallback)(function (e) {
    onMenuItemClick(option, e);
    onClick && onClick(e);
  }, [onClick, onMenuItemClick, option]);
  var active = isOnlyResult || activeIndex === position;

  // Update the item's position in the item stack.
  setItem(option, position);
  return _objectSpread(_objectSpread({}, props), {}, {
    active: active,
    'aria-label': label,
    'aria-selected': active,
    id: (0, _utils.getMenuItemId)(id, position),
    onClick: handleClick,
    onMouseDown: _utils.preventInputBlur,
    ref: itemRef,
    role: 'option'
  });
}

/* istanbul ignore next */
function withItem(Component) {
  (0, _utils.warn)(false, 'Warning: `withItem` is deprecated and will be removed in the next ' + 'major version. Use `useItem` instead.');
  var WrappedMenuItem = function WrappedMenuItem(props) {
    return /*#__PURE__*/_react["default"].createElement(Component, (0, _extends2["default"])({}, props, useItem(props)));
  };
  WrappedMenuItem.displayName = "withItem(".concat((0, _utils.getDisplayName)(Component), ")");
  WrappedMenuItem.propTypes = propTypes;
  return WrappedMenuItem;
}