import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["active", "children", "className", "onRemove", "tabIndex"],
  _excluded2 = ["children", "option", "readOnly"],
  _excluded3 = ["ref"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import cx from 'classnames';
import React, { forwardRef } from 'react';
import ClearButton from '../ClearButton';
import { useToken } from '../../behaviors/token';
import { isFunction } from '../../utils';
var InteractiveToken = /*#__PURE__*/forwardRef(function (_ref, ref) {
  var active = _ref.active,
    children = _ref.children,
    className = _ref.className,
    onRemove = _ref.onRemove,
    tabIndex = _ref.tabIndex,
    props = _objectWithoutProperties(_ref, _excluded);
  return /*#__PURE__*/React.createElement("div", _extends({}, props, {
    className: cx('rbt-token', 'rbt-token-removeable', {
      'rbt-token-active': !!active
    }, className),
    ref: ref,
    tabIndex: tabIndex || 0
  }), children, /*#__PURE__*/React.createElement(ClearButton, {
    className: "rbt-token-remove-button",
    label: "Remove",
    onClick: onRemove,
    tabIndex: -1
  }));
});
var StaticToken = function StaticToken(_ref2) {
  var children = _ref2.children,
    className = _ref2.className,
    disabled = _ref2.disabled,
    href = _ref2.href;
  var classnames = cx('rbt-token', {
    'rbt-token-disabled': disabled
  }, className);
  if (href && !disabled) {
    return /*#__PURE__*/React.createElement("a", {
      className: classnames,
      href: href
    }, children);
  }
  return /*#__PURE__*/React.createElement("div", {
    className: classnames
  }, children);
};
/**
 * Individual token component, generally displayed within the
 * `TypeaheadInputMulti` component, but can also be rendered on its own.
 */
var Token = function Token(_ref3) {
  var children = _ref3.children,
    option = _ref3.option,
    readOnly = _ref3.readOnly,
    props = _objectWithoutProperties(_ref3, _excluded2);
  var _useToken = useToken(_objectSpread(_objectSpread({}, props), {}, {
      option: option
    })),
    ref = _useToken.ref,
    tokenProps = _objectWithoutProperties(_useToken, _excluded3);
  var child = /*#__PURE__*/React.createElement("div", {
    className: "rbt-token-label"
  }, children);
  return !props.disabled && !readOnly && isFunction(tokenProps.onRemove) ? /*#__PURE__*/React.createElement(InteractiveToken, _extends({}, props, tokenProps, {
    ref: ref
  }), child) : /*#__PURE__*/React.createElement(StaticToken, props, child);
};
export default Token;