"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.aas3_0 = exports.aas2_6 = exports.aas2_5 = exports.aas2_4 = exports.aas2_3 = exports.aas2_2 = exports.aas2_1 = exports.aas2_0 = exports.asyncapi2 = exports.asyncApi2 = exports.aas3 = exports.aas2 = void 0;
const json_1 = require("@stoplight/json");
const aas2Regex = /^2\.(0|[1-9][0-9]*)\.(0|[1-9][0-9]*)$/;
const aas3Regex = /^3\.(0|[1-9][0-9]*)\.(0|[1-9][0-9]*)$/;
const aas2_0Regex = /^2\.0(?:\.[0-9]*)?$/;
const aas2_1Regex = /^2\.1(?:\.[0-9]*)?$/;
const aas2_2Regex = /^2\.2(?:\.[0-9]*)?$/;
const aas2_3Regex = /^2\.3(?:\.[0-9]*)?$/;
const aas2_4Regex = /^2\.4(?:\.[0-9]*)?$/;
const aas2_5Regex = /^2\.5(?:\.[0-9]*)?$/;
const aas2_6Regex = /^2\.6(?:\.[0-9]*)?$/;
const aas3_0Regex = /^3\.0(?:\.[0-9]*)?$/;
const isAas2 = (document) => (0, json_1.isPlainObject)(document) && 'asyncapi' in document && aas2Regex.test(String(document.asyncapi));
const isAas3 = (document) => (0, json_1.isPlainObject)(document) && 'asyncapi' in document && aas3Regex.test(String(document.asyncapi));
exports.aas2 = isAas2;
exports.aas2.displayName = 'AsyncAPI 2.x';
exports.aas3 = isAas3;
exports.aas3.displayName = 'AsyncAPI 3.x';
exports.asyncApi2 = exports.aas2;
exports.asyncapi2 = exports.aas2;
const aas2_0 = (document) => isAas2(document) && aas2_0Regex.test(String(document.asyncapi));
exports.aas2_0 = aas2_0;
exports.aas2_0.displayName = 'AsyncAPI 2.0.x';
const aas2_1 = (document) => isAas2(document) && aas2_1Regex.test(String(document.asyncapi));
exports.aas2_1 = aas2_1;
exports.aas2_1.displayName = 'AsyncAPI 2.1.x';
const aas2_2 = (document) => isAas2(document) && aas2_2Regex.test(String(document.asyncapi));
exports.aas2_2 = aas2_2;
exports.aas2_2.displayName = 'AsyncAPI 2.2.x';
const aas2_3 = (document) => isAas2(document) && aas2_3Regex.test(String(document.asyncapi));
exports.aas2_3 = aas2_3;
exports.aas2_3.displayName = 'AsyncAPI 2.3.x';
const aas2_4 = (document) => isAas2(document) && aas2_4Regex.test(String(document.asyncapi));
exports.aas2_4 = aas2_4;
exports.aas2_4.displayName = 'AsyncAPI 2.4.x';
const aas2_5 = (document) => isAas2(document) && aas2_5Regex.test(String(document.asyncapi));
exports.aas2_5 = aas2_5;
exports.aas2_5.displayName = 'AsyncAPI 2.5.x';
const aas2_6 = (document) => isAas2(document) && aas2_6Regex.test(String(document.asyncapi));
exports.aas2_6 = aas2_6;
exports.aas2_6.displayName = 'AsyncAPI 2.6.x';
const aas3_0 = (document) => isAas3(document) && aas3_0Regex.test(String(document.asyncapi));
exports.aas3_0 = aas3_0;
exports.aas3_0.displayName = 'AsyncAPI 3.0.x';
//# sourceMappingURL=asyncapi.js.map