"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classnames = _interopRequireDefault(require("classnames"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _MenuItem = require("../MenuItem");
var _utils = require("../../utils");
var _propTypes2 = require("../../propTypes");
var _excluded = ["emptyLabel", "innerRef", "maxHeight", "style"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { "default": e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && Object.prototype.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n["default"] = e, t && t.set(e, n), n; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { (0, _defineProperty2["default"])(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
var MenuDivider = function MenuDivider() {
  return /*#__PURE__*/_react["default"].createElement("div", {
    className: "dropdown-divider",
    role: "separator"
  });
};
var MenuHeader = function MenuHeader(props) {
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/role-has-required-aria-props
    _react["default"].createElement("div", (0, _extends2["default"])({}, props, {
      className: "dropdown-header",
      role: "heading"
    }))
  );
};
var propTypes = {
  'aria-label': _propTypes["default"].string,
  /**
   * Message to display in the menu if there are no valid results.
   */
  emptyLabel: _propTypes["default"].node,
  /**
   * Needed for accessibility.
   */
  id: (0, _propTypes2.checkPropType)(_propTypes["default"].oneOfType([_propTypes["default"].number, _propTypes["default"].string]), _propTypes2.isRequiredForA11y),
  /**
   * Maximum height of the dropdown menu.
   */
  maxHeight: _propTypes["default"].string
};
/**
 * Menu component that handles empty state when passed a set of results.
 */
var Menu = function Menu(_ref) {
  var _ref$emptyLabel = _ref.emptyLabel,
    emptyLabel = _ref$emptyLabel === void 0 ? 'No matches found.' : _ref$emptyLabel,
    innerRef = _ref.innerRef,
    _ref$maxHeight = _ref.maxHeight,
    maxHeight = _ref$maxHeight === void 0 ? '300px' : _ref$maxHeight,
    style = _ref.style,
    props = (0, _objectWithoutProperties2["default"])(_ref, _excluded);
  var children = _react.Children.count(props.children) === 0 ? /*#__PURE__*/_react["default"].createElement(_MenuItem.BaseMenuItem, {
    disabled: true,
    role: "option"
  }, emptyLabel) : props.children;
  return (
    /*#__PURE__*/
    /* eslint-disable jsx-a11y/interactive-supports-focus */
    _react["default"].createElement("div", (0, _extends2["default"])({}, props, {
      "aria-label": props['aria-label'] || 'menu-options',
      className: (0, _classnames["default"])('rbt-menu', 'dropdown-menu', 'show', props.className),
      onMouseDown:
      // Prevent input from blurring when clicking on the menu scrollbar.
      _utils.preventInputBlur,
      ref: innerRef,
      role: "listbox",
      style: _objectSpread(_objectSpread({}, style), {}, {
        display: 'block',
        maxHeight: maxHeight,
        overflow: 'auto'
      })
    }), children)
    /* eslint-enable jsx-a11y/interactive-supports-focus */
  );
};

Menu.propTypes = propTypes;
Menu.Divider = MenuDivider;
Menu.Header = MenuHeader;
var _default = exports["default"] = Menu;