# JansConfigApi.SoftwareStatementAssertionSSAApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**revokeSsa**](SoftwareStatementAssertionSSAApi.md#revokeSsa) | **DELETE** /api/v1/jans-auth-server/ssa | Revoke existing active SSA based on &#x60;jti&#x60; or &#x60;org_id&#x60;



## revokeSsa

> revokeSsa(opts)

Revoke existing active SSA based on &#x60;jti&#x60; or &#x60;org_id&#x60;

Revoke existing active SSA based on &#x60;jti&#x60; or &#x60;org_id&#x60;

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.SoftwareStatementAssertionSSAApi();
let opts = {
  'authorization': "authorization_example", // String | Authorization code
  'jti': "jti_example" // String | JWT ID - unique identifier for the JWT
};
apiInstance.revokeSsa(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **authorization** | **String**| Authorization code | [optional] 
 **jti** | **String**| JWT ID - unique identifier for the JWT | [optional] 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

