# JansConfigApi.IdentityProvider

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**dn** | **String** |  | [optional] 
**inum** | **String** | Unique identifier. | [optional] 
**creatorId** | **String** | Creator of IDP. | 
**name** | **String** | Name uniquely identifies an identity provider. | 
**displayName** | **String** | Identity provider display name. | 
**description** | **String** | Description of Identity provider. | 
**realm** | **String** | Realm in which Identity provider is created. | 
**enabled** | **Boolean** | Indicates if Identity provider is enabled. | [optional] 
**signingCertificate** | **String** | Digital certificate used to verify the authenticity of the request. | [optional] 
**validateSignature** | **String** |  | [optional] 
**singleLogoutServiceUrl** | **String** | Url used to send logout requests. | [optional] 
**nameIDPolicyFormat** | **String** |  URI reference corresponding to a name identifier format. | [optional] 
**principalAttribute** | **String** |  Name or Friendly Name of the attribute used to identify external users. | [optional] 
**principalType** | **String** | Way to identify and track external users from the assertion. | [optional] 
**idpEntityId** | **String** | Entity ID that will be used to uniquely identify this SAML Service Provider. | [optional] 
**singleSignOnServiceUrl** | **String** | Url used to send SAML authentication requests. | [optional] 
**encryptionPublicKey** | **String** | Public key to use to encrypt the message. | [optional] 
**providerId** | **String** | IDP provider, should be SAML. | [optional] 
**trustEmail** | **Boolean** | If enabled, email provided by this provider is not verified even if verification is enabled for the realm. | [optional] 
**storeToken** | **Boolean** | Enable/disable if tokens must be stored after authenticating users. | [optional] 
**addReadTokenRoleOnCreate** | **Boolean** | Enable/disable if new users can read any stored tokens. | [optional] 
**authenticateByDefault** | **Boolean** |  | [optional] 
**linkOnly** | **Boolean** | If true, users cannot log in through this provider. They can only link to this provider. | [optional] 
**firstBrokerLoginFlowAlias** | **String** | Alias of authentication flow, which is triggered after first login with this identity provider. Term &#39;First Login&#39; means that no Keycloak account is currently linked to the authenticated identity provider account. | [optional] 
**postBrokerLoginFlowAlias** | **String** | Alias of authentication flow, which is triggered after each login with this identity provider. | [optional] 
**spMetaDataURL** | **String** | SAML SP metadata file URL. | [optional] 
**spMetaDataLocation** | **String** | SP metadata file location. | [optional] 
**idpMetaDataURL** | **String** | SAML IDP metadata file URL. | [optional] 
**idpMetaDataLocation** | **String** | SAML IDP metadata file location. | [optional] 
**status** | **String** | IDP setup status. | [optional] 
**validationStatus** | **String** | IDP validation status. | [optional] 
**validationLog** | **[String]** | IDP validation log. | [optional] 
**baseDn** | **String** |  | [optional] 



## Enum: StatusEnum


* `active` (value: `"active"`)

* `inactive` (value: `"inactive"`)

* `expired` (value: `"expired"`)

* `register` (value: `"register"`)





## Enum: ValidationStatusEnum


* `In Progress` (value: `"In Progress"`)

* `Success` (value: `"Success"`)

* `Scheduled` (value: `"Scheduled"`)

* `Failed` (value: `"Failed"`)




