"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _AgamaConfiguration = _interopRequireDefault(require("./AgamaConfiguration"));
var _AssetMgtConfiguration = _interopRequireDefault(require("./AssetMgtConfiguration"));
var _AuditLogConf = _interopRequireDefault(require("./AuditLogConf"));
var _CorsConfigurationFilter = _interopRequireDefault(require("./CorsConfigurationFilter"));
var _DataFormatConversionConf = _interopRequireDefault(require("./DataFormatConversionConf"));
var _PluginConf = _interopRequireDefault(require("./PluginConf"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
 * The ApiAppConfiguration model module.
 * @module model/ApiAppConfiguration
 * @version OAS Version
 */
var ApiAppConfiguration = /*#__PURE__*/function () {
  /**
   * Constructs a new <code>ApiAppConfiguration</code>.
   * @alias module:model/ApiAppConfiguration
   */
  function ApiAppConfiguration() {
    _classCallCheck(this, ApiAppConfiguration);
    ApiAppConfiguration.initialize(this);
  }

  /**
   * Initializes the fields of this object.
   * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
   * Only for internal use.
   */
  return _createClass(ApiAppConfiguration, null, [{
    key: "initialize",
    value: function initialize(obj) {}

    /**
     * Constructs a <code>ApiAppConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ApiAppConfiguration} obj Optional instance to populate.
     * @return {module:model/ApiAppConfiguration} The populated <code>ApiAppConfiguration</code> instance.
     */
  }, {
    key: "constructFromObject",
    value: function constructFromObject(data, obj) {
      if (data) {
        obj = obj || new ApiAppConfiguration();
        if (data.hasOwnProperty('serviceName')) {
          obj['serviceName'] = _ApiClient["default"].convertToType(data['serviceName'], 'String');
        }
        if (data.hasOwnProperty('configOauthEnabled')) {
          obj['configOauthEnabled'] = _ApiClient["default"].convertToType(data['configOauthEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('disableLoggerTimer')) {
          obj['disableLoggerTimer'] = _ApiClient["default"].convertToType(data['disableLoggerTimer'], 'Boolean');
        }
        if (data.hasOwnProperty('disableAuditLogger')) {
          obj['disableAuditLogger'] = _ApiClient["default"].convertToType(data['disableAuditLogger'], 'Boolean');
        }
        if (data.hasOwnProperty('customAttributeValidationEnabled')) {
          obj['customAttributeValidationEnabled'] = _ApiClient["default"].convertToType(data['customAttributeValidationEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('acrValidationEnabled')) {
          obj['acrValidationEnabled'] = _ApiClient["default"].convertToType(data['acrValidationEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('apiApprovedIssuer')) {
          obj['apiApprovedIssuer'] = _ApiClient["default"].convertToType(data['apiApprovedIssuer'], ['String']);
        }
        if (data.hasOwnProperty('apiProtectionType')) {
          obj['apiProtectionType'] = _ApiClient["default"].convertToType(data['apiProtectionType'], 'String');
        }
        if (data.hasOwnProperty('apiClientId')) {
          obj['apiClientId'] = _ApiClient["default"].convertToType(data['apiClientId'], 'String');
        }
        if (data.hasOwnProperty('apiClientPassword')) {
          obj['apiClientPassword'] = _ApiClient["default"].convertToType(data['apiClientPassword'], 'String');
        }
        if (data.hasOwnProperty('endpointInjectionEnabled')) {
          obj['endpointInjectionEnabled'] = _ApiClient["default"].convertToType(data['endpointInjectionEnabled'], 'Boolean');
        }
        if (data.hasOwnProperty('authIssuerUrl')) {
          obj['authIssuerUrl'] = _ApiClient["default"].convertToType(data['authIssuerUrl'], 'String');
        }
        if (data.hasOwnProperty('authOpenidConfigurationUrl')) {
          obj['authOpenidConfigurationUrl'] = _ApiClient["default"].convertToType(data['authOpenidConfigurationUrl'], 'String');
        }
        if (data.hasOwnProperty('authOpenidIntrospectionUrl')) {
          obj['authOpenidIntrospectionUrl'] = _ApiClient["default"].convertToType(data['authOpenidIntrospectionUrl'], 'String');
        }
        if (data.hasOwnProperty('authOpenidTokenUrl')) {
          obj['authOpenidTokenUrl'] = _ApiClient["default"].convertToType(data['authOpenidTokenUrl'], 'String');
        }
        if (data.hasOwnProperty('authOpenidRevokeUrl')) {
          obj['authOpenidRevokeUrl'] = _ApiClient["default"].convertToType(data['authOpenidRevokeUrl'], 'String');
        }
        if (data.hasOwnProperty('exclusiveAuthScopes')) {
          obj['exclusiveAuthScopes'] = _ApiClient["default"].convertToType(data['exclusiveAuthScopes'], ['String']);
        }
        if (data.hasOwnProperty('corsConfigurationFilters')) {
          obj['corsConfigurationFilters'] = _ApiClient["default"].convertToType(data['corsConfigurationFilters'], [_CorsConfigurationFilter["default"]]);
        }
        if (data.hasOwnProperty('loggingLevel')) {
          obj['loggingLevel'] = _ApiClient["default"].convertToType(data['loggingLevel'], 'String');
        }
        if (data.hasOwnProperty('loggingLayout')) {
          obj['loggingLayout'] = _ApiClient["default"].convertToType(data['loggingLayout'], 'String');
        }
        if (data.hasOwnProperty('externalLoggerConfiguration')) {
          obj['externalLoggerConfiguration'] = _ApiClient["default"].convertToType(data['externalLoggerConfiguration'], 'String');
        }
        if (data.hasOwnProperty('disableJdkLogger')) {
          obj['disableJdkLogger'] = _ApiClient["default"].convertToType(data['disableJdkLogger'], 'Boolean');
        }
        if (data.hasOwnProperty('maxCount')) {
          obj['maxCount'] = _ApiClient["default"].convertToType(data['maxCount'], 'Number');
        }
        if (data.hasOwnProperty('acrExclusionList')) {
          obj['acrExclusionList'] = _ApiClient["default"].convertToType(data['acrExclusionList'], ['String']);
        }
        if (data.hasOwnProperty('userExclusionAttributes')) {
          obj['userExclusionAttributes'] = _ApiClient["default"].convertToType(data['userExclusionAttributes'], ['String']);
        }
        if (data.hasOwnProperty('userMandatoryAttributes')) {
          obj['userMandatoryAttributes'] = _ApiClient["default"].convertToType(data['userMandatoryAttributes'], ['String']);
        }
        if (data.hasOwnProperty('agamaConfiguration')) {
          obj['agamaConfiguration'] = _AgamaConfiguration["default"].constructFromObject(data['agamaConfiguration']);
        }
        if (data.hasOwnProperty('auditLogConf')) {
          obj['auditLogConf'] = _AuditLogConf["default"].constructFromObject(data['auditLogConf']);
        }
        if (data.hasOwnProperty('dataFormatConversionConf')) {
          obj['dataFormatConversionConf'] = _DataFormatConversionConf["default"].constructFromObject(data['dataFormatConversionConf']);
        }
        if (data.hasOwnProperty('plugins')) {
          obj['plugins'] = _ApiClient["default"].convertToType(data['plugins'], [_PluginConf["default"]]);
        }
        if (data.hasOwnProperty('assetMgtConfiguration')) {
          obj['assetMgtConfiguration'] = _AssetMgtConfiguration["default"].constructFromObject(data['assetMgtConfiguration']);
        }
      }
      return obj;
    }
  }]);
}();
/**
 * Config API service name.
 * @member {String} serviceName
 */
ApiAppConfiguration.prototype['serviceName'] = undefined;

/**
 * OAuth authentication enable/disable flag. Default value `true`.
 * @member {Boolean} configOauthEnabled
 */
ApiAppConfiguration.prototype['configOauthEnabled'] = undefined;

/**
 * Flag to enable/disable timer to dynamically reflect log configuration changes. Default value `true`Default value `false`.
 * @member {Boolean} disableLoggerTimer
 */
ApiAppConfiguration.prototype['disableLoggerTimer'] = undefined;

/**
 * Flag to enable/disable request audit. Default value `false`.
 * @member {Boolean} disableAuditLogger
 */
ApiAppConfiguration.prototype['disableAuditLogger'] = undefined;

/**
 * Flag to enable/disable check if custom attribue is declared in schema. Default value `true`.
 * @member {Boolean} customAttributeValidationEnabled
 */
ApiAppConfiguration.prototype['customAttributeValidationEnabled'] = undefined;

/**
 * Flag to enable/disable check if acr customScript is enabled. Default value `true`.
 * @member {Boolean} acrValidationEnabled
 */
ApiAppConfiguration.prototype['acrValidationEnabled'] = undefined;

/**
 * List of approved external Auth server to validate token.
 * @member {Array.<String>} apiApprovedIssuer
 */
ApiAppConfiguration.prototype['apiApprovedIssuer'] = undefined;

/**
 * Name of supported API protection mechansim. Supported type is `OAuth2`.
 * @member {String} apiProtectionType
 */
ApiAppConfiguration.prototype['apiProtectionType'] = undefined;

/**
 * Config-API client ID.
 * @member {String} apiClientId
 */
ApiAppConfiguration.prototype['apiClientId'] = undefined;

/**
 * Config-API client password.
 * @member {String} apiClientPassword
 */
ApiAppConfiguration.prototype['apiClientPassword'] = undefined;

/**
 * @member {Boolean} endpointInjectionEnabled
 */
ApiAppConfiguration.prototype['endpointInjectionEnabled'] = undefined;

/**
 * Issuer Identifier of Jans OpenID Connect Provider.
 * @member {String} authIssuerUrl
 */
ApiAppConfiguration.prototype['authIssuerUrl'] = undefined;

/**
 * Jans OpenID Connect Provider Well-Known Configuration URL.
 * @member {String} authOpenidConfigurationUrl
 */
ApiAppConfiguration.prototype['authOpenidConfigurationUrl'] = undefined;

/**
 * Jans URL of the OpenID Connect Provider's OAuth 2.0 Authorization Endpoint.
 * @member {String} authOpenidIntrospectionUrl
 */
ApiAppConfiguration.prototype['authOpenidIntrospectionUrl'] = undefined;

/**
 * Jans URL of the OpenID Connect Provider's OAuth 2.0 Token Endpoint.
 * @member {String} authOpenidTokenUrl
 */
ApiAppConfiguration.prototype['authOpenidTokenUrl'] = undefined;

/**
 * Jans URL of the OpenID Connect Provider's OAuth 2.0 Revoke Token Endpoint.
 * @member {String} authOpenidRevokeUrl
 */
ApiAppConfiguration.prototype['authOpenidRevokeUrl'] = undefined;

/**
 * List of oAuth scope that can be validity for an access tokens only by underlying Jans Auth server.
 * @member {Array.<String>} exclusiveAuthScopes
 */
ApiAppConfiguration.prototype['exclusiveAuthScopes'] = undefined;

/**
 * CORS configuration filter properties.
 * @member {Array.<module:model/CorsConfigurationFilter>} corsConfigurationFilters
 */
ApiAppConfiguration.prototype['corsConfigurationFilters'] = undefined;

/**
 * Specify logging level of Loggers. Default level is `INFO`.
 * @member {String} loggingLevel
 */
ApiAppConfiguration.prototype['loggingLevel'] = undefined;

/**
 * Log4j logging layout. Default value `TEXT`.
 * @member {String} loggingLayout
 */
ApiAppConfiguration.prototype['loggingLayout'] = undefined;

/**
 * The path to the external log4j2 logging configuration.
 * @member {String} externalLoggerConfiguration
 */
ApiAppConfiguration.prototype['externalLoggerConfiguration'] = undefined;

/**
 * Choose whether to disable JDK loggers.
 * @member {Boolean} disableJdkLogger
 */
ApiAppConfiguration.prototype['disableJdkLogger'] = undefined;

/**
 * Maximum number of results per page in search endpoints.
 * @member {Number} maxCount
 */
ApiAppConfiguration.prototype['maxCount'] = undefined;

/**
 * List of ACR values that should be excluded from active validation check.
 * @member {Array.<String>} acrExclusionList
 */
ApiAppConfiguration.prototype['acrExclusionList'] = undefined;

/**
 * User attribute that should not be returned in response.
 * @member {Array.<String>} userExclusionAttributes
 */
ApiAppConfiguration.prototype['userExclusionAttributes'] = undefined;

/**
 * List of User mandatory attribute for user creation request.
 * @member {Array.<String>} userMandatoryAttributes
 */
ApiAppConfiguration.prototype['userMandatoryAttributes'] = undefined;

/**
 * @member {module:model/AgamaConfiguration} agamaConfiguration
 */
ApiAppConfiguration.prototype['agamaConfiguration'] = undefined;

/**
 * @member {module:model/AuditLogConf} auditLogConf
 */
ApiAppConfiguration.prototype['auditLogConf'] = undefined;

/**
 * @member {module:model/DataFormatConversionConf} dataFormatConversionConf
 */
ApiAppConfiguration.prototype['dataFormatConversionConf'] = undefined;

/**
 * Details of enabled plugins.
 * @member {Array.<module:model/PluginConf>} plugins
 */
ApiAppConfiguration.prototype['plugins'] = undefined;

/**
 * @member {module:model/AssetMgtConfiguration} assetMgtConfiguration
 */
ApiAppConfiguration.prototype['assetMgtConfiguration'] = undefined;
var _default = exports["default"] = ApiAppConfiguration;