"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _SessionId = _interopRequireDefault(require("../model/SessionId"));
var _SessionPagedResult = _interopRequireDefault(require("../model/SessionPagedResult"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* AuthSessionManagement service.
* @module api/AuthSessionManagementApi
* @version OAS Version
*/
var AuthSessionManagementApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new AuthSessionManagementApi. 
  * @alias module:api/AuthSessionManagementApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function AuthSessionManagementApi(apiClient) {
    _classCallCheck(this, AuthSessionManagementApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteSession operation.
   * @callback module:api/AuthSessionManagementApi~deleteSessionCallback
   * @param {String} error Error message, if any.
   * @param data This operation does not return a value.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Delete a session.
   * Delete a session.
   * @param {String} sid Session identifier.
   * @param {module:api/AuthSessionManagementApi~deleteSessionCallback} callback The callback function, accepting three arguments: error, data, response
   */
  return _createClass(AuthSessionManagementApi, [{
    key: "deleteSession",
    value: function deleteSession(sid, callback) {
      var postBody = null;
      // verify the required parameter 'sid' is set
      if (sid === undefined || sid === null) {
        throw new Error("Missing the required parameter 'sid' when calling deleteSession");
      }
      var pathParams = {
        'sid': sid
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/jans-auth-server/session/sid/{sid}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getSessionById operation.
     * @callback module:api/AuthSessionManagementApi~getSessionByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SessionId} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Get session by id.
     * Get session by id.
     * @param {String} sid Session identifier.
     * @param {module:api/AuthSessionManagementApi~getSessionByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SessionId}
     */
  }, {
    key: "getSessionById",
    value: function getSessionById(sid, callback) {
      var postBody = null;
      // verify the required parameter 'sid' is set
      if (sid === undefined || sid === null) {
        throw new Error("Missing the required parameter 'sid' when calling getSessionById");
      }
      var pathParams = {
        'sid': sid
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _SessionId["default"];
      return this.apiClient.callApi('/api/v1/jans-auth-server/session/sid/{sid}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getSessions operation.
     * @callback module:api/AuthSessionManagementApi~getSessionsCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SessionPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Return all session
     * Return all session
     * @param {module:api/AuthSessionManagementApi~getSessionsCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SessionPagedResult}
     */
  }, {
    key: "getSessions",
    value: function getSessions(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _SessionPagedResult["default"];
      return this.apiClient.callApi('/api/v1/jans-auth-server/session', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the revokeUserSession operation.
     * @callback module:api/AuthSessionManagementApi~revokeUserSessionCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Revoke all sessions by userDn
     * Revoke all sessions by userDn
     * @param {String} userDn User domain name
     * @param {module:api/AuthSessionManagementApi~revokeUserSessionCallback} callback The callback function, accepting three arguments: error, data, response
     */
  }, {
    key: "revokeUserSession",
    value: function revokeUserSession(userDn, callback) {
      var postBody = null;
      // verify the required parameter 'userDn' is set
      if (userDn === undefined || userDn === null) {
        throw new Error("Missing the required parameter 'userDn' when calling revokeUserSession");
      }
      var pathParams = {
        'userDn': userDn
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = [];
      var returnType = null;
      return this.apiClient.callApi('/api/v1/jans-auth-server/session/user/{userDn}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the searchSession operation.
     * @callback module:api/AuthSessionManagementApi~searchSessionCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SessionPagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Search session
     * Search session
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'jansId')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/AuthSessionManagementApi~searchSessionCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SessionPagedResult}
     */
  }, {
    key: "searchSession",
    value: function searchSession(opts, callback) {
      opts = opts || {};
      var postBody = null;
      var pathParams = {};
      var queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _SessionPagedResult["default"];
      return this.apiClient.callApi('/api/v1/jans-auth-server/session/search', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();