# JansConfigApi.AdminUIWebhooksApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteWebhookByInum**](AdminUIWebhooksApi.md#deleteWebhookByInum) | **DELETE** /admin-ui/webhook/{webhookId} | Delete Webhook
[**getAllFeatures**](AdminUIWebhooksApi.md#getAllFeatures) | **GET** /admin-ui/webhook/features | Gets list of Admin UI features
[**getAllWebhooks**](AdminUIWebhooksApi.md#getAllWebhooks) | **GET** /admin-ui/webhook | Gets list of webhooks
[**getFeaturesByWebhookId**](AdminUIWebhooksApi.md#getFeaturesByWebhookId) | **GET** /admin-ui/webhook/features/{webhookId} | Gets list of Admin UI features mapped to webhookId
[**getWebhooksByFeatureId**](AdminUIWebhooksApi.md#getWebhooksByFeatureId) | **GET** /admin-ui/webhook/{featureId} | Gets list of Admin UI Webhooks mapped to featureId
[**postWebhook**](AdminUIWebhooksApi.md#postWebhook) | **POST** /admin-ui/webhook | Create Webhook
[**putWebhook**](AdminUIWebhooksApi.md#putWebhook) | **PUT** /admin-ui/webhook | Update Webhook
[**triggerWebhook**](AdminUIWebhooksApi.md#triggerWebhook) | **POST** /admin-ui/webhook/trigger/{featureId} | Trigger webhooks mapped to featureId



## deleteWebhookByInum

> deleteWebhookByInum(webhookId)

Delete Webhook

Delete Webhook

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIWebhooksApi();
let webhookId = "webhookId_example"; // String | Webhook identifier
apiInstance.deleteWebhookByInum(webhookId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **webhookId** | **String**| Webhook identifier | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAllFeatures

> AuiFeature getAllFeatures()

Gets list of Admin UI features

Gets list of Admin UI features

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIWebhooksApi();
apiInstance.getAllFeatures((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**AuiFeature**](AuiFeature.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAllWebhooks

> PagedResult getAllWebhooks(opts)

Gets list of webhooks

Gets list of webhooks

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIWebhooksApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': scopeType=spontaneous,defaultScope=true // String | Field and value pair for seraching
};
apiInstance.getAllWebhooks(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getFeaturesByWebhookId

> AuiFeature getFeaturesByWebhookId(webhookId)

Gets list of Admin UI features mapped to webhookId

Gets list of Admin UI features mapped to webhookId

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIWebhooksApi();
let webhookId = "webhookId_example"; // String | Webhook identifier
apiInstance.getFeaturesByWebhookId(webhookId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **webhookId** | **String**| Webhook identifier | 

### Return type

[**AuiFeature**](AuiFeature.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getWebhooksByFeatureId

> WebhookEntry getWebhooksByFeatureId(featureId)

Gets list of Admin UI Webhooks mapped to featureId

Gets list of Admin UI Webhooks mapped to featureId

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIWebhooksApi();
let featureId = "featureId_example"; // String | Feature identifier
apiInstance.getWebhooksByFeatureId(featureId, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **featureId** | **String**| Feature identifier | 

### Return type

[**WebhookEntry**](WebhookEntry.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## postWebhook

> Scope postWebhook(opts)

Create Webhook

Create Webhook

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIWebhooksApi();
let opts = {
  'webhookEntry': {
  "displayName": "posts-webhook-1",
  "description": "posts-webhook description",
  "url": "https://reqres.in/api/users",
  "httpRequestBody": {
    "name": "morpheus",
    "job": "leader"
  },
  "httpMethod": "POST",
  "jansEnabled": true,
  "httpHeaders":[{"key":"Content-Type", "value":"application/json"}],
  "auiFeatureIds":["jans_link_write"]
}
 // WebhookEntry | Webhook object
};
apiInstance.postWebhook(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **webhookEntry** | [**WebhookEntry**](WebhookEntry.md)| Webhook object | [optional] 

### Return type

[**Scope**](Scope.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## putWebhook

> WebhookEntry putWebhook(opts)

Update Webhook

Update Webhook

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIWebhooksApi();
let opts = {
  'webhookEntry': {
  "dn": "inum=2d3fe60f-db3f-3ab8-a285-e71e935ff282,ou=auiWebhooks,ou=admin-ui,o=jans",
  "inum": "2d3fe60f-db3f-3ab8-a285-e71e935ff282",
  "displayName": "posts-webhook-1",
  "description": "posts-webhook description",
  "url": "https://jsonplaceholder.typicode.com/posts",
  "httpRequestBody": "{\"userId\": 11,\"id\": 11,\"title\": \"sunt aut facere repellat provident occaecati excepturi optio reprehenderit\",\"body\": \"quia et suscipitsuscipit recusandae consequuntur expedita et cumreprehenderit molestiae ut ut quas otamnostrum rerum est autem sunt rem eveniet architecto\"}",
  "httpMethod": "POST",
  "jansEnabled": true,
  "httpHeaders": [{
    "key": "Content-Type",
    "value": "application/json"
  }],
  "auiFeatureIds": ["jans_link_write"],
  "baseDn": "inum=2d3fe60f-db3f-3ab8-a285-e71e935ff282,ou=auiWebhooks,ou=admin-ui,o=jans"
}
 // WebhookEntry | Webhook object
};
apiInstance.putWebhook(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **webhookEntry** | [**WebhookEntry**](WebhookEntry.md)| Webhook object | [optional] 

### Return type

[**WebhookEntry**](WebhookEntry.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json


## triggerWebhook

> AuiFeature triggerWebhook(featureId, opts)

Trigger webhooks mapped to featureId

Trigger webhooks mapped to featureId

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.AdminUIWebhooksApi();
let featureId = "featureId_example"; // String | Admin UI feature identifier
let opts = {
  'shortCodeRequest': [{
  "webhookId": "0a8e784b-2394-3a34-89d3-4a09d245aa32",
  "shortcodeValueMap": {"price": 100}
}]
 // ShortCodeRequest | Webhook object
};
apiInstance.triggerWebhook(featureId, opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **featureId** | **String**| Admin UI feature identifier | 
 **shortCodeRequest** | [**ShortCodeRequest**](ShortCodeRequest.md)| Webhook object | [optional] 

### Return type

[**AuiFeature**](AuiFeature.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

