"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _AppConfiguration = _interopRequireDefault(require("../model/AppConfiguration"));
var _PersistenceConfiguration = _interopRequireDefault(require("../model/PersistenceConfiguration"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* ConfigurationProperties service.
* @module api/ConfigurationPropertiesApi
* @version OAS Version
*/
var ConfigurationPropertiesApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new ConfigurationPropertiesApi. 
  * @alias module:api/ConfigurationPropertiesApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function ConfigurationPropertiesApi(apiClient) {
    _classCallCheck(this, ConfigurationPropertiesApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the getFeatureFlagType operation.
   * @callback module:api/ConfigurationPropertiesApi~getFeatureFlagTypeCallback
   * @param {String} error Error message, if any.
   * @param {Array.<String>} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Returns feature flags type configured for Jans authorization server.
   * Returns feature flags type configured for Jans authorization server.
   * @param {module:api/ConfigurationPropertiesApi~getFeatureFlagTypeCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link Array.<String>}
   */
  return _createClass(ConfigurationPropertiesApi, [{
    key: "getFeatureFlagType",
    value: function getFeatureFlagType(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = ['String'];
      return this.apiClient.callApi('/api/v1/jans-auth-server/config/feature-flags', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getProperties operation.
     * @callback module:api/ConfigurationPropertiesApi~getPropertiesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AppConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets all Jans authorization server configuration properties.
     * Gets all Jans authorization server configuration properties.
     * @param {module:api/ConfigurationPropertiesApi~getPropertiesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AppConfiguration}
     */
  }, {
    key: "getProperties",
    value: function getProperties(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _AppConfiguration["default"];
      return this.apiClient.callApi('/api/v1/jans-auth-server/config', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getPropertiesPersistence operation.
     * @callback module:api/ConfigurationPropertiesApi~getPropertiesPersistenceCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PersistenceConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Returns persistence type configured for Jans authorization server.
     * Returns persistence type configured for Jans authorization server.
     * @param {module:api/ConfigurationPropertiesApi~getPropertiesPersistenceCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PersistenceConfiguration}
     */
  }, {
    key: "getPropertiesPersistence",
    value: function getPropertiesPersistence(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _PersistenceConfiguration["default"];
      return this.apiClient.callApi('/api/v1/jans-auth-server/config/persistence', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchProperties operation.
     * @callback module:api/ConfigurationPropertiesApi~patchPropertiesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/AppConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Partially modifies Jans authorization server Application configuration properties.
     * Partially modifies Jans authorization server AppConfiguration properties.
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/ConfigurationPropertiesApi~patchPropertiesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/AppConfiguration}
     */
  }, {
    key: "patchProperties",
    value: function patchProperties(opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _AppConfiguration["default"];
      return this.apiClient.callApi('/api/v1/jans-auth-server/config', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();