import getMatchBounds from './getMatchBounds';
import getOptionLabel from './getOptionLabel';
import hasOwnProperty from './hasOwnProperty';
import { isString } from './nodash';
function getHintText({ activeIndex, initialItem, isFocused, isMenuShown, labelKey, multiple, selected, text, }) {
    if (!text ||
        !isFocused ||
        !isMenuShown ||
        !initialItem ||
        (!isString(initialItem) && hasOwnProperty(initialItem, 'customOption')) ||
        (!isString(initialItem) && initialItem.disabled) ||
        activeIndex > -1 ||
        (!!selected.length && !multiple)) {
        return '';
    }
    const initialItemStr = getOptionLabel(initialItem, labelKey);
    const bounds = getMatchBounds(initialItemStr.toLowerCase(), text.toLowerCase());
    if (!(bounds && bounds.start === 0)) {
        return '';
    }
    return text + initialItemStr.slice(bounds.end, initialItemStr.length);
}
export default getHintText;
