import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
var _excluded = ["emptyLabel", "innerRef", "maxHeight", "style"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
import cx from 'classnames';
import PropTypes from 'prop-types';
import React, { Children } from 'react';
import { BaseMenuItem } from '../MenuItem';
import { preventInputBlur } from '../../utils';
import { checkPropType, isRequiredForA11y } from '../../propTypes';
var MenuDivider = function MenuDivider() {
  return /*#__PURE__*/React.createElement("div", {
    className: "dropdown-divider",
    role: "separator"
  });
};
var MenuHeader = function MenuHeader(props) {
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/role-has-required-aria-props
    React.createElement("div", _extends({}, props, {
      className: "dropdown-header",
      role: "heading"
    }))
  );
};
var propTypes = {
  'aria-label': PropTypes.string,
  /**
   * Message to display in the menu if there are no valid results.
   */
  emptyLabel: PropTypes.node,
  /**
   * Needed for accessibility.
   */
  id: checkPropType(PropTypes.oneOfType([PropTypes.number, PropTypes.string]), isRequiredForA11y),
  /**
   * Maximum height of the dropdown menu.
   */
  maxHeight: PropTypes.string
};
/**
 * Menu component that handles empty state when passed a set of results.
 */
var Menu = function Menu(_ref) {
  var _ref$emptyLabel = _ref.emptyLabel,
    emptyLabel = _ref$emptyLabel === void 0 ? 'No matches found.' : _ref$emptyLabel,
    innerRef = _ref.innerRef,
    _ref$maxHeight = _ref.maxHeight,
    maxHeight = _ref$maxHeight === void 0 ? '300px' : _ref$maxHeight,
    style = _ref.style,
    props = _objectWithoutProperties(_ref, _excluded);
  var children = Children.count(props.children) === 0 ? /*#__PURE__*/React.createElement(BaseMenuItem, {
    disabled: true,
    role: "option"
  }, emptyLabel) : props.children;
  return (
    /*#__PURE__*/
    /* eslint-disable jsx-a11y/interactive-supports-focus */
    React.createElement("div", _extends({}, props, {
      "aria-label": props['aria-label'] || 'menu-options',
      className: cx('rbt-menu', 'dropdown-menu', 'show', props.className),
      onMouseDown:
      // Prevent input from blurring when clicking on the menu scrollbar.
      preventInputBlur,
      ref: innerRef,
      role: "listbox",
      style: _objectSpread(_objectSpread({}, style), {}, {
        display: 'block',
        maxHeight: maxHeight,
        overflow: 'auto'
      })
    }), children)
    /* eslint-enable jsx-a11y/interactive-supports-focus */
  );
};

Menu.propTypes = propTypes;
Menu.Divider = MenuDivider;
Menu.Header = MenuHeader;
export default Menu;