/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import ClientAttributes from './ClientAttributes';
import CustomObjectAttribute from './CustomObjectAttribute';
import LocalizedString from './LocalizedString';

/**
 * The Client model module.
 * @module model/Client
 * @version OAS Version
 */
class Client {
    /**
     * Constructs a new <code>Client</code>.
     * @alias module:model/Client
     */
    constructor() { 
        
        Client.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>Client</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/Client} obj Optional instance to populate.
     * @return {module:model/Client} The populated <code>Client</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new Client();

            if (data.hasOwnProperty('dn')) {
                obj['dn'] = ApiClient.convertToType(data['dn'], 'String');
            }
            if (data.hasOwnProperty('expirationDate')) {
                obj['expirationDate'] = ApiClient.convertToType(data['expirationDate'], 'Date');
            }
            if (data.hasOwnProperty('deletable')) {
                obj['deletable'] = ApiClient.convertToType(data['deletable'], 'Boolean');
            }
            if (data.hasOwnProperty('clientSecret')) {
                obj['clientSecret'] = ApiClient.convertToType(data['clientSecret'], 'String');
            }
            if (data.hasOwnProperty('frontChannelLogoutUri')) {
                obj['frontChannelLogoutUri'] = ApiClient.convertToType(data['frontChannelLogoutUri'], 'String');
            }
            if (data.hasOwnProperty('frontChannelLogoutSessionRequired')) {
                obj['frontChannelLogoutSessionRequired'] = ApiClient.convertToType(data['frontChannelLogoutSessionRequired'], 'Boolean');
            }
            if (data.hasOwnProperty('registrationAccessToken')) {
                obj['registrationAccessToken'] = ApiClient.convertToType(data['registrationAccessToken'], 'String');
            }
            if (data.hasOwnProperty('clientIdIssuedAt')) {
                obj['clientIdIssuedAt'] = ApiClient.convertToType(data['clientIdIssuedAt'], 'Date');
            }
            if (data.hasOwnProperty('clientSecretExpiresAt')) {
                obj['clientSecretExpiresAt'] = ApiClient.convertToType(data['clientSecretExpiresAt'], 'Date');
            }
            if (data.hasOwnProperty('redirectUris')) {
                obj['redirectUris'] = ApiClient.convertToType(data['redirectUris'], ['String']);
            }
            if (data.hasOwnProperty('claimRedirectUris')) {
                obj['claimRedirectUris'] = ApiClient.convertToType(data['claimRedirectUris'], ['String']);
            }
            if (data.hasOwnProperty('responseTypes')) {
                obj['responseTypes'] = ApiClient.convertToType(data['responseTypes'], ['String']);
            }
            if (data.hasOwnProperty('grantTypes')) {
                obj['grantTypes'] = ApiClient.convertToType(data['grantTypes'], ['String']);
            }
            if (data.hasOwnProperty('applicationType')) {
                obj['applicationType'] = ApiClient.convertToType(data['applicationType'], 'String');
            }
            if (data.hasOwnProperty('contacts')) {
                obj['contacts'] = ApiClient.convertToType(data['contacts'], ['String']);
            }
            if (data.hasOwnProperty('idTokenTokenBindingCnf')) {
                obj['idTokenTokenBindingCnf'] = ApiClient.convertToType(data['idTokenTokenBindingCnf'], 'String');
            }
            if (data.hasOwnProperty('clientName')) {
                obj['clientName'] = ApiClient.convertToType(data['clientName'], 'String');
            }
            if (data.hasOwnProperty('logoUri')) {
                obj['logoUri'] = ApiClient.convertToType(data['logoUri'], 'String');
            }
            if (data.hasOwnProperty('clientUri')) {
                obj['clientUri'] = ApiClient.convertToType(data['clientUri'], 'String');
            }
            if (data.hasOwnProperty('policyUri')) {
                obj['policyUri'] = ApiClient.convertToType(data['policyUri'], 'String');
            }
            if (data.hasOwnProperty('tosUri')) {
                obj['tosUri'] = ApiClient.convertToType(data['tosUri'], 'String');
            }
            if (data.hasOwnProperty('clientNameLocalized')) {
                obj['clientNameLocalized'] = LocalizedString.constructFromObject(data['clientNameLocalized']);
            }
            if (data.hasOwnProperty('logoUriLocalized')) {
                obj['logoUriLocalized'] = LocalizedString.constructFromObject(data['logoUriLocalized']);
            }
            if (data.hasOwnProperty('clientUriLocalized')) {
                obj['clientUriLocalized'] = LocalizedString.constructFromObject(data['clientUriLocalized']);
            }
            if (data.hasOwnProperty('policyUriLocalized')) {
                obj['policyUriLocalized'] = LocalizedString.constructFromObject(data['policyUriLocalized']);
            }
            if (data.hasOwnProperty('tosUriLocalized')) {
                obj['tosUriLocalized'] = LocalizedString.constructFromObject(data['tosUriLocalized']);
            }
            if (data.hasOwnProperty('jwksUri')) {
                obj['jwksUri'] = ApiClient.convertToType(data['jwksUri'], 'String');
            }
            if (data.hasOwnProperty('jwks')) {
                obj['jwks'] = ApiClient.convertToType(data['jwks'], 'String');
            }
            if (data.hasOwnProperty('sectorIdentifierUri')) {
                obj['sectorIdentifierUri'] = ApiClient.convertToType(data['sectorIdentifierUri'], 'String');
            }
            if (data.hasOwnProperty('subjectType')) {
                obj['subjectType'] = ApiClient.convertToType(data['subjectType'], 'String');
            }
            if (data.hasOwnProperty('idTokenSignedResponseAlg')) {
                obj['idTokenSignedResponseAlg'] = ApiClient.convertToType(data['idTokenSignedResponseAlg'], 'String');
            }
            if (data.hasOwnProperty('idTokenEncryptedResponseAlg')) {
                obj['idTokenEncryptedResponseAlg'] = ApiClient.convertToType(data['idTokenEncryptedResponseAlg'], 'String');
            }
            if (data.hasOwnProperty('idTokenEncryptedResponseEnc')) {
                obj['idTokenEncryptedResponseEnc'] = ApiClient.convertToType(data['idTokenEncryptedResponseEnc'], 'String');
            }
            if (data.hasOwnProperty('userInfoSignedResponseAlg')) {
                obj['userInfoSignedResponseAlg'] = ApiClient.convertToType(data['userInfoSignedResponseAlg'], 'String');
            }
            if (data.hasOwnProperty('userInfoEncryptedResponseAlg')) {
                obj['userInfoEncryptedResponseAlg'] = ApiClient.convertToType(data['userInfoEncryptedResponseAlg'], 'String');
            }
            if (data.hasOwnProperty('userInfoEncryptedResponseEnc')) {
                obj['userInfoEncryptedResponseEnc'] = ApiClient.convertToType(data['userInfoEncryptedResponseEnc'], 'String');
            }
            if (data.hasOwnProperty('requestObjectSigningAlg')) {
                obj['requestObjectSigningAlg'] = ApiClient.convertToType(data['requestObjectSigningAlg'], 'String');
            }
            if (data.hasOwnProperty('requestObjectEncryptionAlg')) {
                obj['requestObjectEncryptionAlg'] = ApiClient.convertToType(data['requestObjectEncryptionAlg'], 'String');
            }
            if (data.hasOwnProperty('requestObjectEncryptionEnc')) {
                obj['requestObjectEncryptionEnc'] = ApiClient.convertToType(data['requestObjectEncryptionEnc'], 'String');
            }
            if (data.hasOwnProperty('tokenEndpointAuthMethod')) {
                obj['tokenEndpointAuthMethod'] = ApiClient.convertToType(data['tokenEndpointAuthMethod'], 'String');
            }
            if (data.hasOwnProperty('tokenEndpointAuthSigningAlg')) {
                obj['tokenEndpointAuthSigningAlg'] = ApiClient.convertToType(data['tokenEndpointAuthSigningAlg'], 'String');
            }
            if (data.hasOwnProperty('defaultMaxAge')) {
                obj['defaultMaxAge'] = ApiClient.convertToType(data['defaultMaxAge'], 'Number');
            }
            if (data.hasOwnProperty('defaultAcrValues')) {
                obj['defaultAcrValues'] = ApiClient.convertToType(data['defaultAcrValues'], ['String']);
            }
            if (data.hasOwnProperty('initiateLoginUri')) {
                obj['initiateLoginUri'] = ApiClient.convertToType(data['initiateLoginUri'], 'String');
            }
            if (data.hasOwnProperty('postLogoutRedirectUris')) {
                obj['postLogoutRedirectUris'] = ApiClient.convertToType(data['postLogoutRedirectUris'], ['String']);
            }
            if (data.hasOwnProperty('requestUris')) {
                obj['requestUris'] = ApiClient.convertToType(data['requestUris'], ['String']);
            }
            if (data.hasOwnProperty('scopes')) {
                obj['scopes'] = ApiClient.convertToType(data['scopes'], ['String']);
            }
            if (data.hasOwnProperty('claims')) {
                obj['claims'] = ApiClient.convertToType(data['claims'], ['String']);
            }
            if (data.hasOwnProperty('trustedClient')) {
                obj['trustedClient'] = ApiClient.convertToType(data['trustedClient'], 'Boolean');
            }
            if (data.hasOwnProperty('lastAccessTime')) {
                obj['lastAccessTime'] = ApiClient.convertToType(data['lastAccessTime'], 'Date');
            }
            if (data.hasOwnProperty('lastLogonTime')) {
                obj['lastLogonTime'] = ApiClient.convertToType(data['lastLogonTime'], 'Date');
            }
            if (data.hasOwnProperty('persistClientAuthorizations')) {
                obj['persistClientAuthorizations'] = ApiClient.convertToType(data['persistClientAuthorizations'], 'Boolean');
            }
            if (data.hasOwnProperty('includeClaimsInIdToken')) {
                obj['includeClaimsInIdToken'] = ApiClient.convertToType(data['includeClaimsInIdToken'], 'Boolean');
            }
            if (data.hasOwnProperty('refreshTokenLifetime')) {
                obj['refreshTokenLifetime'] = ApiClient.convertToType(data['refreshTokenLifetime'], 'Number');
            }
            if (data.hasOwnProperty('accessTokenLifetime')) {
                obj['accessTokenLifetime'] = ApiClient.convertToType(data['accessTokenLifetime'], 'Number');
            }
            if (data.hasOwnProperty('customAttributes')) {
                obj['customAttributes'] = ApiClient.convertToType(data['customAttributes'], [CustomObjectAttribute]);
            }
            if (data.hasOwnProperty('customObjectClasses')) {
                obj['customObjectClasses'] = ApiClient.convertToType(data['customObjectClasses'], ['String']);
            }
            if (data.hasOwnProperty('rptAsJwt')) {
                obj['rptAsJwt'] = ApiClient.convertToType(data['rptAsJwt'], 'Boolean');
            }
            if (data.hasOwnProperty('accessTokenAsJwt')) {
                obj['accessTokenAsJwt'] = ApiClient.convertToType(data['accessTokenAsJwt'], 'Boolean');
            }
            if (data.hasOwnProperty('accessTokenSigningAlg')) {
                obj['accessTokenSigningAlg'] = ApiClient.convertToType(data['accessTokenSigningAlg'], 'String');
            }
            if (data.hasOwnProperty('disabled')) {
                obj['disabled'] = ApiClient.convertToType(data['disabled'], 'Boolean');
            }
            if (data.hasOwnProperty('authorizedOrigins')) {
                obj['authorizedOrigins'] = ApiClient.convertToType(data['authorizedOrigins'], ['String']);
            }
            if (data.hasOwnProperty('softwareId')) {
                obj['softwareId'] = ApiClient.convertToType(data['softwareId'], 'String');
            }
            if (data.hasOwnProperty('softwareVersion')) {
                obj['softwareVersion'] = ApiClient.convertToType(data['softwareVersion'], 'String');
            }
            if (data.hasOwnProperty('softwareStatement')) {
                obj['softwareStatement'] = ApiClient.convertToType(data['softwareStatement'], 'String');
            }
            if (data.hasOwnProperty('attributes')) {
                obj['attributes'] = ClientAttributes.constructFromObject(data['attributes']);
            }
            if (data.hasOwnProperty('backchannelTokenDeliveryMode')) {
                obj['backchannelTokenDeliveryMode'] = ApiClient.convertToType(data['backchannelTokenDeliveryMode'], 'String');
            }
            if (data.hasOwnProperty('backchannelClientNotificationEndpoint')) {
                obj['backchannelClientNotificationEndpoint'] = ApiClient.convertToType(data['backchannelClientNotificationEndpoint'], 'String');
            }
            if (data.hasOwnProperty('backchannelAuthenticationRequestSigningAlg')) {
                obj['backchannelAuthenticationRequestSigningAlg'] = ApiClient.convertToType(data['backchannelAuthenticationRequestSigningAlg'], 'String');
            }
            if (data.hasOwnProperty('backchannelUserCodeParameter')) {
                obj['backchannelUserCodeParameter'] = ApiClient.convertToType(data['backchannelUserCodeParameter'], 'Boolean');
            }
            if (data.hasOwnProperty('description')) {
                obj['description'] = ApiClient.convertToType(data['description'], 'String');
            }
            if (data.hasOwnProperty('organization')) {
                obj['organization'] = ApiClient.convertToType(data['organization'], 'String');
            }
            if (data.hasOwnProperty('groups')) {
                obj['groups'] = ApiClient.convertToType(data['groups'], ['String']);
            }
            if (data.hasOwnProperty('ttl')) {
                obj['ttl'] = ApiClient.convertToType(data['ttl'], 'Number');
            }
            if (data.hasOwnProperty('displayName')) {
                obj['displayName'] = ApiClient.convertToType(data['displayName'], 'String');
            }
            if (data.hasOwnProperty('baseDn')) {
                obj['baseDn'] = ApiClient.convertToType(data['baseDn'], 'String');
            }
            if (data.hasOwnProperty('inum')) {
                obj['inum'] = ApiClient.convertToType(data['inum'], 'String');
            }
        }
        return obj;
    }


}

/**
 * @member {String} dn
 */
Client.prototype['dn'] = undefined;

/**
 * @member {Date} expirationDate
 */
Client.prototype['expirationDate'] = undefined;

/**
 * @member {Boolean} deletable
 */
Client.prototype['deletable'] = undefined;

/**
 * @member {String} clientSecret
 */
Client.prototype['clientSecret'] = undefined;

/**
 * @member {String} frontChannelLogoutUri
 */
Client.prototype['frontChannelLogoutUri'] = undefined;

/**
 * @member {Boolean} frontChannelLogoutSessionRequired
 */
Client.prototype['frontChannelLogoutSessionRequired'] = undefined;

/**
 * @member {String} registrationAccessToken
 */
Client.prototype['registrationAccessToken'] = undefined;

/**
 * @member {Date} clientIdIssuedAt
 */
Client.prototype['clientIdIssuedAt'] = undefined;

/**
 * @member {Date} clientSecretExpiresAt
 */
Client.prototype['clientSecretExpiresAt'] = undefined;

/**
 * @member {Array.<String>} redirectUris
 */
Client.prototype['redirectUris'] = undefined;

/**
 * @member {Array.<String>} claimRedirectUris
 */
Client.prototype['claimRedirectUris'] = undefined;

/**
 * @member {Array.<module:model/Client.ResponseTypesEnum>} responseTypes
 */
Client.prototype['responseTypes'] = undefined;

/**
 * @member {Array.<module:model/Client.GrantTypesEnum>} grantTypes
 */
Client.prototype['grantTypes'] = undefined;

/**
 * @member {module:model/Client.ApplicationTypeEnum} applicationType
 */
Client.prototype['applicationType'] = undefined;

/**
 * @member {Array.<String>} contacts
 */
Client.prototype['contacts'] = undefined;

/**
 * @member {String} idTokenTokenBindingCnf
 */
Client.prototype['idTokenTokenBindingCnf'] = undefined;

/**
 * @member {String} clientName
 */
Client.prototype['clientName'] = undefined;

/**
 * @member {String} logoUri
 */
Client.prototype['logoUri'] = undefined;

/**
 * @member {String} clientUri
 */
Client.prototype['clientUri'] = undefined;

/**
 * @member {String} policyUri
 */
Client.prototype['policyUri'] = undefined;

/**
 * @member {String} tosUri
 */
Client.prototype['tosUri'] = undefined;

/**
 * @member {module:model/LocalizedString} clientNameLocalized
 */
Client.prototype['clientNameLocalized'] = undefined;

/**
 * @member {module:model/LocalizedString} logoUriLocalized
 */
Client.prototype['logoUriLocalized'] = undefined;

/**
 * @member {module:model/LocalizedString} clientUriLocalized
 */
Client.prototype['clientUriLocalized'] = undefined;

/**
 * @member {module:model/LocalizedString} policyUriLocalized
 */
Client.prototype['policyUriLocalized'] = undefined;

/**
 * @member {module:model/LocalizedString} tosUriLocalized
 */
Client.prototype['tosUriLocalized'] = undefined;

/**
 * @member {String} jwksUri
 */
Client.prototype['jwksUri'] = undefined;

/**
 * @member {String} jwks
 */
Client.prototype['jwks'] = undefined;

/**
 * @member {String} sectorIdentifierUri
 */
Client.prototype['sectorIdentifierUri'] = undefined;

/**
 * @member {module:model/Client.SubjectTypeEnum} subjectType
 */
Client.prototype['subjectType'] = undefined;

/**
 * @member {String} idTokenSignedResponseAlg
 */
Client.prototype['idTokenSignedResponseAlg'] = undefined;

/**
 * @member {String} idTokenEncryptedResponseAlg
 */
Client.prototype['idTokenEncryptedResponseAlg'] = undefined;

/**
 * @member {String} idTokenEncryptedResponseEnc
 */
Client.prototype['idTokenEncryptedResponseEnc'] = undefined;

/**
 * @member {String} userInfoSignedResponseAlg
 */
Client.prototype['userInfoSignedResponseAlg'] = undefined;

/**
 * @member {String} userInfoEncryptedResponseAlg
 */
Client.prototype['userInfoEncryptedResponseAlg'] = undefined;

/**
 * @member {String} userInfoEncryptedResponseEnc
 */
Client.prototype['userInfoEncryptedResponseEnc'] = undefined;

/**
 * @member {String} requestObjectSigningAlg
 */
Client.prototype['requestObjectSigningAlg'] = undefined;

/**
 * @member {String} requestObjectEncryptionAlg
 */
Client.prototype['requestObjectEncryptionAlg'] = undefined;

/**
 * @member {String} requestObjectEncryptionEnc
 */
Client.prototype['requestObjectEncryptionEnc'] = undefined;

/**
 * @member {module:model/Client.TokenEndpointAuthMethodEnum} tokenEndpointAuthMethod
 */
Client.prototype['tokenEndpointAuthMethod'] = undefined;

/**
 * @member {String} tokenEndpointAuthSigningAlg
 */
Client.prototype['tokenEndpointAuthSigningAlg'] = undefined;

/**
 * @member {Number} defaultMaxAge
 */
Client.prototype['defaultMaxAge'] = undefined;

/**
 * @member {Array.<String>} defaultAcrValues
 */
Client.prototype['defaultAcrValues'] = undefined;

/**
 * @member {String} initiateLoginUri
 */
Client.prototype['initiateLoginUri'] = undefined;

/**
 * @member {Array.<String>} postLogoutRedirectUris
 */
Client.prototype['postLogoutRedirectUris'] = undefined;

/**
 * @member {Array.<String>} requestUris
 */
Client.prototype['requestUris'] = undefined;

/**
 * @member {Array.<String>} scopes
 */
Client.prototype['scopes'] = undefined;

/**
 * @member {Array.<String>} claims
 */
Client.prototype['claims'] = undefined;

/**
 * @member {Boolean} trustedClient
 */
Client.prototype['trustedClient'] = undefined;

/**
 * @member {Date} lastAccessTime
 */
Client.prototype['lastAccessTime'] = undefined;

/**
 * @member {Date} lastLogonTime
 */
Client.prototype['lastLogonTime'] = undefined;

/**
 * @member {Boolean} persistClientAuthorizations
 */
Client.prototype['persistClientAuthorizations'] = undefined;

/**
 * @member {Boolean} includeClaimsInIdToken
 */
Client.prototype['includeClaimsInIdToken'] = undefined;

/**
 * @member {Number} refreshTokenLifetime
 */
Client.prototype['refreshTokenLifetime'] = undefined;

/**
 * @member {Number} accessTokenLifetime
 */
Client.prototype['accessTokenLifetime'] = undefined;

/**
 * @member {Array.<module:model/CustomObjectAttribute>} customAttributes
 */
Client.prototype['customAttributes'] = undefined;

/**
 * @member {Array.<String>} customObjectClasses
 */
Client.prototype['customObjectClasses'] = undefined;

/**
 * @member {Boolean} rptAsJwt
 */
Client.prototype['rptAsJwt'] = undefined;

/**
 * @member {Boolean} accessTokenAsJwt
 */
Client.prototype['accessTokenAsJwt'] = undefined;

/**
 * @member {String} accessTokenSigningAlg
 */
Client.prototype['accessTokenSigningAlg'] = undefined;

/**
 * @member {Boolean} disabled
 */
Client.prototype['disabled'] = undefined;

/**
 * @member {Array.<String>} authorizedOrigins
 */
Client.prototype['authorizedOrigins'] = undefined;

/**
 * @member {String} softwareId
 */
Client.prototype['softwareId'] = undefined;

/**
 * @member {String} softwareVersion
 */
Client.prototype['softwareVersion'] = undefined;

/**
 * @member {String} softwareStatement
 */
Client.prototype['softwareStatement'] = undefined;

/**
 * @member {module:model/ClientAttributes} attributes
 */
Client.prototype['attributes'] = undefined;

/**
 * @member {module:model/Client.BackchannelTokenDeliveryModeEnum} backchannelTokenDeliveryMode
 */
Client.prototype['backchannelTokenDeliveryMode'] = undefined;

/**
 * @member {String} backchannelClientNotificationEndpoint
 */
Client.prototype['backchannelClientNotificationEndpoint'] = undefined;

/**
 * @member {module:model/Client.BackchannelAuthenticationRequestSigningAlgEnum} backchannelAuthenticationRequestSigningAlg
 */
Client.prototype['backchannelAuthenticationRequestSigningAlg'] = undefined;

/**
 * @member {Boolean} backchannelUserCodeParameter
 */
Client.prototype['backchannelUserCodeParameter'] = undefined;

/**
 * @member {String} description
 */
Client.prototype['description'] = undefined;

/**
 * @member {String} organization
 */
Client.prototype['organization'] = undefined;

/**
 * @member {Array.<String>} groups
 */
Client.prototype['groups'] = undefined;

/**
 * @member {Number} ttl
 */
Client.prototype['ttl'] = undefined;

/**
 * @member {String} displayName
 */
Client.prototype['displayName'] = undefined;

/**
 * @member {String} baseDn
 */
Client.prototype['baseDn'] = undefined;

/**
 * @member {String} inum
 */
Client.prototype['inum'] = undefined;





/**
 * Allowed values for the <code>responseTypes</code> property.
 * @enum {String}
 * @readonly
 */
Client['ResponseTypesEnum'] = {

    /**
     * value: "code"
     * @const
     */
    "code": "code",

    /**
     * value: "token"
     * @const
     */
    "token": "token",

    /**
     * value: "id_token"
     * @const
     */
    "id_token": "id_token"
};


/**
 * Allowed values for the <code>grantTypes</code> property.
 * @enum {String}
 * @readonly
 */
Client['GrantTypesEnum'] = {

    /**
     * value: "none"
     * @const
     */
    "none": "none",

    /**
     * value: "authorization_code"
     * @const
     */
    "authorization_code": "authorization_code",

    /**
     * value: "implicit"
     * @const
     */
    "implicit": "implicit",

    /**
     * value: "password"
     * @const
     */
    "password": "password",

    /**
     * value: "client_credentials"
     * @const
     */
    "client_credentials": "client_credentials",

    /**
     * value: "refresh_token"
     * @const
     */
    "refresh_token": "refresh_token",

    /**
     * value: "urn:ietf:params:oauth:grant-type:uma-ticket"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:uma-ticket": "urn:ietf:params:oauth:grant-type:uma-ticket",

    /**
     * value: "urn:ietf:params:oauth:grant-type:token-exchange"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:token-exchange": "urn:ietf:params:oauth:grant-type:token-exchange",

    /**
     * value: "urn:openid:params:grant-type:ciba"
     * @const
     */
    "urn:openid:params:grant-type:ciba": "urn:openid:params:grant-type:ciba",

    /**
     * value: "urn:ietf:params:oauth:grant-type:device_code"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:device_code": "urn:ietf:params:oauth:grant-type:device_code",

    /**
     * value: "urn:ietf:params:oauth:grant-type:jwt-bearer"
     * @const
     */
    "urn:ietf:params:oauth:grant-type:jwt-bearer": "urn:ietf:params:oauth:grant-type:jwt-bearer"
};


/**
 * Allowed values for the <code>applicationType</code> property.
 * @enum {String}
 * @readonly
 */
Client['ApplicationTypeEnum'] = {

    /**
     * value: "native"
     * @const
     */
    "native": "native",

    /**
     * value: "web"
     * @const
     */
    "web": "web"
};


/**
 * Allowed values for the <code>subjectType</code> property.
 * @enum {String}
 * @readonly
 */
Client['SubjectTypeEnum'] = {

    /**
     * value: "pairwise"
     * @const
     */
    "pairwise": "pairwise",

    /**
     * value: "public"
     * @const
     */
    "public": "public"
};


/**
 * Allowed values for the <code>tokenEndpointAuthMethod</code> property.
 * @enum {String}
 * @readonly
 */
Client['TokenEndpointAuthMethodEnum'] = {

    /**
     * value: "client_secret_basic"
     * @const
     */
    "client_secret_basic": "client_secret_basic",

    /**
     * value: "client_secret_post"
     * @const
     */
    "client_secret_post": "client_secret_post",

    /**
     * value: "client_secret_jwt"
     * @const
     */
    "client_secret_jwt": "client_secret_jwt",

    /**
     * value: "private_key_jwt"
     * @const
     */
    "private_key_jwt": "private_key_jwt",

    /**
     * value: "access_token"
     * @const
     */
    "access_token": "access_token",

    /**
     * value: "tls_client_auth"
     * @const
     */
    "tls_client_auth": "tls_client_auth",

    /**
     * value: "self_signed_tls_client_auth"
     * @const
     */
    "self_signed_tls_client_auth": "self_signed_tls_client_auth",

    /**
     * value: "none"
     * @const
     */
    "none": "none"
};


/**
 * Allowed values for the <code>backchannelTokenDeliveryMode</code> property.
 * @enum {String}
 * @readonly
 */
Client['BackchannelTokenDeliveryModeEnum'] = {

    /**
     * value: "poll"
     * @const
     */
    "poll": "poll",

    /**
     * value: "ping"
     * @const
     */
    "ping": "ping",

    /**
     * value: "push"
     * @const
     */
    "push": "push"
};


/**
 * Allowed values for the <code>backchannelAuthenticationRequestSigningAlg</code> property.
 * @enum {String}
 * @readonly
 */
Client['BackchannelAuthenticationRequestSigningAlgEnum'] = {

    /**
     * value: "RS256"
     * @const
     */
    "RS256": "RS256",

    /**
     * value: "RS384"
     * @const
     */
    "RS384": "RS384",

    /**
     * value: "RS512"
     * @const
     */
    "RS512": "RS512",

    /**
     * value: "ES256"
     * @const
     */
    "ES256": "ES256",

    /**
     * value: "ES384"
     * @const
     */
    "ES384": "ES384",

    /**
     * value: "ES512"
     * @const
     */
    "ES512": "ES512",

    /**
     * value: "PS256"
     * @const
     */
    "PS256": "PS256",

    /**
     * value: "PS384"
     * @const
     */
    "PS384": "PS384",

    /**
     * value: "PS512"
     * @const
     */
    "PS512": "PS512"
};



export default Client;

