/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import PolicySource from './PolicySource';

/**
 * The CedarlingConfiguration model module.
 * @module model/CedarlingConfiguration
 * @version OAS Version
 */
class CedarlingConfiguration {
    /**
     * Constructs a new <code>CedarlingConfiguration</code>.
     * Cedarling configuration
     * @alias module:model/CedarlingConfiguration
     */
    constructor() { 
        
        CedarlingConfiguration.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>CedarlingConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/CedarlingConfiguration} obj Optional instance to populate.
     * @return {module:model/CedarlingConfiguration} The populated <code>CedarlingConfiguration</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new CedarlingConfiguration();

            if (data.hasOwnProperty('enabled')) {
                obj['enabled'] = ApiClient.convertToType(data['enabled'], 'Boolean');
            }
            if (data.hasOwnProperty('policySources')) {
                obj['policySources'] = ApiClient.convertToType(data['policySources'], [PolicySource]);
            }
            if (data.hasOwnProperty('logType')) {
                obj['logType'] = ApiClient.convertToType(data['logType'], 'String');
            }
            if (data.hasOwnProperty('logLevel')) {
                obj['logLevel'] = ApiClient.convertToType(data['logLevel'], 'String');
            }
            if (data.hasOwnProperty('externalPolicyStoreUri')) {
                obj['externalPolicyStoreUri'] = ApiClient.convertToType(data['externalPolicyStoreUri'], 'String');
            }
        }
        return obj;
    }


}

/**
 * Specify if Cedraling is enabled
 * @member {Boolean} enabled
 */
CedarlingConfiguration.prototype['enabled'] = undefined;

/**
 * List of Policy Sources
 * @member {Array.<module:model/PolicySource>} policySources
 */
CedarlingConfiguration.prototype['policySources'] = undefined;

/**
 * Log type: off, memory, std_out
 * @member {module:model/CedarlingConfiguration.LogTypeEnum} logType
 */
CedarlingConfiguration.prototype['logType'] = undefined;

/**
 * System Log Level
 * @member {module:model/CedarlingConfiguration.LogLevelEnum} logLevel
 */
CedarlingConfiguration.prototype['logLevel'] = undefined;

/**
 * External policy store URI
 * @member {String} externalPolicyStoreUri
 */
CedarlingConfiguration.prototype['externalPolicyStoreUri'] = undefined;





/**
 * Allowed values for the <code>logType</code> property.
 * @enum {String}
 * @readonly
 */
CedarlingConfiguration['LogTypeEnum'] = {

    /**
     * value: "OFF"
     * @const
     */
    "OFF": "OFF",

    /**
     * value: "MEMORY"
     * @const
     */
    "MEMORY": "MEMORY",

    /**
     * value: "STD_OUT"
     * @const
     */
    "STD_OUT": "STD_OUT"
};


/**
 * Allowed values for the <code>logLevel</code> property.
 * @enum {String}
 * @readonly
 */
CedarlingConfiguration['LogLevelEnum'] = {

    /**
     * value: "FATAL"
     * @const
     */
    "FATAL": "FATAL",

    /**
     * value: "ERROR"
     * @const
     */
    "ERROR": "ERROR",

    /**
     * value: "WARN"
     * @const
     */
    "WARN": "WARN",

    /**
     * value: "INFO"
     * @const
     */
    "INFO": "INFO",

    /**
     * value: "DEBUG"
     * @const
     */
    "DEBUG": "DEBUG",

    /**
     * value: "TRACE"
     * @const
     */
    "TRACE": "TRACE"
};



export default CedarlingConfiguration;

