/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import AgamaConfiguration from './AgamaConfiguration';
import AssetMgtConfiguration from './AssetMgtConfiguration';
import AuditLogConf from './AuditLogConf';
import CorsConfigurationFilter from './CorsConfigurationFilter';
import DataFormatConversionConf from './DataFormatConversionConf';
import PluginConf from './PluginConf';

/**
 * The ApiAppConfiguration model module.
 * @module model/ApiAppConfiguration
 * @version OAS Version
 */
class ApiAppConfiguration {
    /**
     * Constructs a new <code>ApiAppConfiguration</code>.
     * @alias module:model/ApiAppConfiguration
     */
    constructor() { 
        
        ApiAppConfiguration.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>ApiAppConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/ApiAppConfiguration} obj Optional instance to populate.
     * @return {module:model/ApiAppConfiguration} The populated <code>ApiAppConfiguration</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new ApiAppConfiguration();

            if (data.hasOwnProperty('serviceName')) {
                obj['serviceName'] = ApiClient.convertToType(data['serviceName'], 'String');
            }
            if (data.hasOwnProperty('configOauthEnabled')) {
                obj['configOauthEnabled'] = ApiClient.convertToType(data['configOauthEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('disableLoggerTimer')) {
                obj['disableLoggerTimer'] = ApiClient.convertToType(data['disableLoggerTimer'], 'Boolean');
            }
            if (data.hasOwnProperty('disableAuditLogger')) {
                obj['disableAuditLogger'] = ApiClient.convertToType(data['disableAuditLogger'], 'Boolean');
            }
            if (data.hasOwnProperty('customAttributeValidationEnabled')) {
                obj['customAttributeValidationEnabled'] = ApiClient.convertToType(data['customAttributeValidationEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('acrValidationEnabled')) {
                obj['acrValidationEnabled'] = ApiClient.convertToType(data['acrValidationEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('apiApprovedIssuer')) {
                obj['apiApprovedIssuer'] = ApiClient.convertToType(data['apiApprovedIssuer'], ['String']);
            }
            if (data.hasOwnProperty('apiProtectionType')) {
                obj['apiProtectionType'] = ApiClient.convertToType(data['apiProtectionType'], 'String');
            }
            if (data.hasOwnProperty('apiClientId')) {
                obj['apiClientId'] = ApiClient.convertToType(data['apiClientId'], 'String');
            }
            if (data.hasOwnProperty('apiClientPassword')) {
                obj['apiClientPassword'] = ApiClient.convertToType(data['apiClientPassword'], 'String');
            }
            if (data.hasOwnProperty('endpointInjectionEnabled')) {
                obj['endpointInjectionEnabled'] = ApiClient.convertToType(data['endpointInjectionEnabled'], 'Boolean');
            }
            if (data.hasOwnProperty('authIssuerUrl')) {
                obj['authIssuerUrl'] = ApiClient.convertToType(data['authIssuerUrl'], 'String');
            }
            if (data.hasOwnProperty('authOpenidConfigurationUrl')) {
                obj['authOpenidConfigurationUrl'] = ApiClient.convertToType(data['authOpenidConfigurationUrl'], 'String');
            }
            if (data.hasOwnProperty('authOpenidIntrospectionUrl')) {
                obj['authOpenidIntrospectionUrl'] = ApiClient.convertToType(data['authOpenidIntrospectionUrl'], 'String');
            }
            if (data.hasOwnProperty('authOpenidTokenUrl')) {
                obj['authOpenidTokenUrl'] = ApiClient.convertToType(data['authOpenidTokenUrl'], 'String');
            }
            if (data.hasOwnProperty('authOpenidRevokeUrl')) {
                obj['authOpenidRevokeUrl'] = ApiClient.convertToType(data['authOpenidRevokeUrl'], 'String');
            }
            if (data.hasOwnProperty('exclusiveAuthScopes')) {
                obj['exclusiveAuthScopes'] = ApiClient.convertToType(data['exclusiveAuthScopes'], ['String']);
            }
            if (data.hasOwnProperty('corsConfigurationFilters')) {
                obj['corsConfigurationFilters'] = ApiClient.convertToType(data['corsConfigurationFilters'], [CorsConfigurationFilter]);
            }
            if (data.hasOwnProperty('loggingLevel')) {
                obj['loggingLevel'] = ApiClient.convertToType(data['loggingLevel'], 'String');
            }
            if (data.hasOwnProperty('loggingLayout')) {
                obj['loggingLayout'] = ApiClient.convertToType(data['loggingLayout'], 'String');
            }
            if (data.hasOwnProperty('externalLoggerConfiguration')) {
                obj['externalLoggerConfiguration'] = ApiClient.convertToType(data['externalLoggerConfiguration'], 'String');
            }
            if (data.hasOwnProperty('disableJdkLogger')) {
                obj['disableJdkLogger'] = ApiClient.convertToType(data['disableJdkLogger'], 'Boolean');
            }
            if (data.hasOwnProperty('maxCount')) {
                obj['maxCount'] = ApiClient.convertToType(data['maxCount'], 'Number');
            }
            if (data.hasOwnProperty('acrExclusionList')) {
                obj['acrExclusionList'] = ApiClient.convertToType(data['acrExclusionList'], ['String']);
            }
            if (data.hasOwnProperty('userExclusionAttributes')) {
                obj['userExclusionAttributes'] = ApiClient.convertToType(data['userExclusionAttributes'], ['String']);
            }
            if (data.hasOwnProperty('userMandatoryAttributes')) {
                obj['userMandatoryAttributes'] = ApiClient.convertToType(data['userMandatoryAttributes'], ['String']);
            }
            if (data.hasOwnProperty('agamaConfiguration')) {
                obj['agamaConfiguration'] = AgamaConfiguration.constructFromObject(data['agamaConfiguration']);
            }
            if (data.hasOwnProperty('auditLogConf')) {
                obj['auditLogConf'] = AuditLogConf.constructFromObject(data['auditLogConf']);
            }
            if (data.hasOwnProperty('dataFormatConversionConf')) {
                obj['dataFormatConversionConf'] = DataFormatConversionConf.constructFromObject(data['dataFormatConversionConf']);
            }
            if (data.hasOwnProperty('plugins')) {
                obj['plugins'] = ApiClient.convertToType(data['plugins'], [PluginConf]);
            }
            if (data.hasOwnProperty('assetMgtConfiguration')) {
                obj['assetMgtConfiguration'] = AssetMgtConfiguration.constructFromObject(data['assetMgtConfiguration']);
            }
        }
        return obj;
    }


}

/**
 * Config API service name.
 * @member {String} serviceName
 */
ApiAppConfiguration.prototype['serviceName'] = undefined;

/**
 * OAuth authentication enable/disable flag. Default value `true`.
 * @member {Boolean} configOauthEnabled
 */
ApiAppConfiguration.prototype['configOauthEnabled'] = undefined;

/**
 * Flag to enable/disable timer to dynamically reflect log configuration changes. Default value `true`Default value `false`.
 * @member {Boolean} disableLoggerTimer
 */
ApiAppConfiguration.prototype['disableLoggerTimer'] = undefined;

/**
 * Flag to enable/disable request audit. Default value `false`.
 * @member {Boolean} disableAuditLogger
 */
ApiAppConfiguration.prototype['disableAuditLogger'] = undefined;

/**
 * Flag to enable/disable check if custom attribue is declared in schema. Default value `true`.
 * @member {Boolean} customAttributeValidationEnabled
 */
ApiAppConfiguration.prototype['customAttributeValidationEnabled'] = undefined;

/**
 * Flag to enable/disable check if acr customScript is enabled. Default value `true`.
 * @member {Boolean} acrValidationEnabled
 */
ApiAppConfiguration.prototype['acrValidationEnabled'] = undefined;

/**
 * List of approved external Auth server to validate token.
 * @member {Array.<String>} apiApprovedIssuer
 */
ApiAppConfiguration.prototype['apiApprovedIssuer'] = undefined;

/**
 * Name of supported API protection mechansim. Supported type is `OAuth2`.
 * @member {String} apiProtectionType
 */
ApiAppConfiguration.prototype['apiProtectionType'] = undefined;

/**
 * Config-API client ID.
 * @member {String} apiClientId
 */
ApiAppConfiguration.prototype['apiClientId'] = undefined;

/**
 * Config-API client password.
 * @member {String} apiClientPassword
 */
ApiAppConfiguration.prototype['apiClientPassword'] = undefined;

/**
 * @member {Boolean} endpointInjectionEnabled
 */
ApiAppConfiguration.prototype['endpointInjectionEnabled'] = undefined;

/**
 * Issuer Identifier of Jans OpenID Connect Provider.
 * @member {String} authIssuerUrl
 */
ApiAppConfiguration.prototype['authIssuerUrl'] = undefined;

/**
 * Jans OpenID Connect Provider Well-Known Configuration URL.
 * @member {String} authOpenidConfigurationUrl
 */
ApiAppConfiguration.prototype['authOpenidConfigurationUrl'] = undefined;

/**
 * Jans URL of the OpenID Connect Provider's OAuth 2.0 Authorization Endpoint.
 * @member {String} authOpenidIntrospectionUrl
 */
ApiAppConfiguration.prototype['authOpenidIntrospectionUrl'] = undefined;

/**
 * Jans URL of the OpenID Connect Provider's OAuth 2.0 Token Endpoint.
 * @member {String} authOpenidTokenUrl
 */
ApiAppConfiguration.prototype['authOpenidTokenUrl'] = undefined;

/**
 * Jans URL of the OpenID Connect Provider's OAuth 2.0 Revoke Token Endpoint.
 * @member {String} authOpenidRevokeUrl
 */
ApiAppConfiguration.prototype['authOpenidRevokeUrl'] = undefined;

/**
 * List of oAuth scope that can be validity for an access tokens only by underlying Jans Auth server.
 * @member {Array.<String>} exclusiveAuthScopes
 */
ApiAppConfiguration.prototype['exclusiveAuthScopes'] = undefined;

/**
 * CORS configuration filter properties.
 * @member {Array.<module:model/CorsConfigurationFilter>} corsConfigurationFilters
 */
ApiAppConfiguration.prototype['corsConfigurationFilters'] = undefined;

/**
 * Specify logging level of Loggers. Default level is `INFO`.
 * @member {String} loggingLevel
 */
ApiAppConfiguration.prototype['loggingLevel'] = undefined;

/**
 * Log4j logging layout. Default value `TEXT`.
 * @member {String} loggingLayout
 */
ApiAppConfiguration.prototype['loggingLayout'] = undefined;

/**
 * The path to the external log4j2 logging configuration.
 * @member {String} externalLoggerConfiguration
 */
ApiAppConfiguration.prototype['externalLoggerConfiguration'] = undefined;

/**
 * Choose whether to disable JDK loggers.
 * @member {Boolean} disableJdkLogger
 */
ApiAppConfiguration.prototype['disableJdkLogger'] = undefined;

/**
 * Maximum number of results per page in search endpoints.
 * @member {Number} maxCount
 */
ApiAppConfiguration.prototype['maxCount'] = undefined;

/**
 * List of ACR values that should be excluded from active validation check.
 * @member {Array.<String>} acrExclusionList
 */
ApiAppConfiguration.prototype['acrExclusionList'] = undefined;

/**
 * User attribute that should not be returned in response.
 * @member {Array.<String>} userExclusionAttributes
 */
ApiAppConfiguration.prototype['userExclusionAttributes'] = undefined;

/**
 * List of User mandatory attribute for user creation request.
 * @member {Array.<String>} userMandatoryAttributes
 */
ApiAppConfiguration.prototype['userMandatoryAttributes'] = undefined;

/**
 * @member {module:model/AgamaConfiguration} agamaConfiguration
 */
ApiAppConfiguration.prototype['agamaConfiguration'] = undefined;

/**
 * @member {module:model/AuditLogConf} auditLogConf
 */
ApiAppConfiguration.prototype['auditLogConf'] = undefined;

/**
 * @member {module:model/DataFormatConversionConf} dataFormatConversionConf
 */
ApiAppConfiguration.prototype['dataFormatConversionConf'] = undefined;

/**
 * Details of enabled plugins.
 * @member {Array.<module:model/PluginConf>} plugins
 */
ApiAppConfiguration.prototype['plugins'] = undefined;

/**
 * @member {module:model/AssetMgtConfiguration} assetMgtConfiguration
 */
ApiAppConfiguration.prototype['assetMgtConfiguration'] = undefined;






export default ApiAppConfiguration;

