# JansConfigApi.JansAssetsApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAsset**](JansAssetsApi.md#deleteAsset) | **DELETE** /api/v1/jans-assets/{inum} | Delete an asset
[**getAllAssets**](JansAssetsApi.md#getAllAssets) | **GET** /api/v1/jans-assets | Gets all Jans assets.
[**getAssetByInum**](JansAssetsApi.md#getAssetByInum) | **GET** /api/v1/jans-assets/{inum} | Gets an asset by inum - unique identifier
[**getAssetByName**](JansAssetsApi.md#getAssetByName) | **GET** /api/v1/jans-assets/name/{name} | Fetch asset by name
[**getAssetDirMapping**](JansAssetsApi.md#getAssetDirMapping) | **GET** /api/v1/jans-assets/asset-dir-mapping | Get valid asset types
[**getAssetServices**](JansAssetsApi.md#getAssetServices) | **GET** /api/v1/jans-assets/services | Gets asset services
[**getAssetTypes**](JansAssetsApi.md#getAssetTypes) | **GET** /api/v1/jans-assets/asset-type | Get valid asset types
[**loadServiceAsset**](JansAssetsApi.md#loadServiceAsset) | **POST** /api/v1/jans-assets/service/{service-name} | Load assets on server for a service
[**postNewAsset**](JansAssetsApi.md#postNewAsset) | **POST** /api/v1/jans-assets/upload | Upload new asset
[**putAsset**](JansAssetsApi.md#putAsset) | **PUT** /api/v1/jans-assets/upload | Update existing asset



## deleteAsset

> deleteAsset(inum)

Delete an asset

Delete an asset

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
let inum = "inum_example"; // String | Asset identifier
apiInstance.deleteAsset(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully.');
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Asset identifier | 

### Return type

null (empty response body)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAllAssets

> DocumentPagedResult getAllAssets(opts)

Gets all Jans assets.

Gets all Jans assets.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
let opts = {
  'limit': 50, // Number | Search size - max size of the results to return
  'pattern': "''", // String | Search pattern
  'status': "'all'", // String | Status of the attribute
  'startIndex': 0, // Number | The 1-based index of the first query result
  'sortBy': "'inum'", // String | Attribute whose value will be used to order the returned response
  'sortOrder': "'ascending'", // String | Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\"
  'fieldValuePair': adminCanEdit=true,dataType=string // String | Field and value pair for seraching
};
apiInstance.getAllAssets(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **limit** | **Number**| Search size - max size of the results to return | [optional] [default to 50]
 **pattern** | **String**| Search pattern | [optional] [default to &#39;&#39;]
 **status** | **String**| Status of the attribute | [optional] [default to &#39;all&#39;]
 **startIndex** | **Number**| The 1-based index of the first query result | [optional] [default to 0]
 **sortBy** | **String**| Attribute whose value will be used to order the returned response | [optional] [default to &#39;inum&#39;]
 **sortOrder** | **String**| Order in which the sortBy param is applied. Allowed values are \&quot;ascending\&quot; and \&quot;descending\&quot; | [optional] [default to &#39;ascending&#39;]
 **fieldValuePair** | **String**| Field and value pair for seraching | [optional] [default to &#39;&#39;]

### Return type

[**DocumentPagedResult**](DocumentPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAssetByInum

> PagedResult getAssetByInum(inum)

Gets an asset by inum - unique identifier

Gets an asset by inum - unique identifier

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
let inum = "inum_example"; // String | Asset Inum
apiInstance.getAssetByInum(inum, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inum** | **String**| Asset Inum | 

### Return type

[**PagedResult**](PagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAssetByName

> DocumentPagedResult getAssetByName(name)

Fetch asset by name

Fetch asset by name.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
let name = "name_example"; // String | Asset Name
apiInstance.getAssetByName(name, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **name** | **String**| Asset Name | 

### Return type

[**DocumentPagedResult**](DocumentPagedResult.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAssetDirMapping

> [AssetDirMapping] getAssetDirMapping()

Get valid asset types

Get valid asset types

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
apiInstance.getAssetDirMapping((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**[AssetDirMapping]**](AssetDirMapping.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAssetServices

> [String] getAssetServices()

Gets asset services

Gets asset services

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
apiInstance.getAssetServices((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

**[String]**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## getAssetTypes

> [String] getAssetTypes()

Get valid asset types

Get valid asset types

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
apiInstance.getAssetTypes((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

**[String]**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## loadServiceAsset

> String loadServiceAsset(serviceName)

Load assets on server for a service

Load assets on server for a service

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
let serviceName = "serviceName_example"; // String | Service Name
apiInstance.loadServiceAsset(serviceName, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **serviceName** | **String**| Service Name | 

### Return type

**String**

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json


## postNewAsset

> Document postNewAsset(document, assetFile)

Upload new asset

Upload new asset

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
let document = new JansConfigApi.Document(); // Document | 
let assetFile = "/path/to/file"; // File | 
apiInstance.postNewAsset(document, assetFile, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **document** | [**Document**](Document.md)|  | 
 **assetFile** | **File**|  | 

### Return type

[**Document**](Document.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json-patch+json, application/json


## putAsset

> Document putAsset(document, assetFile)

Update existing asset

Update existing asset

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.JansAssetsApi();
let document = new JansConfigApi.Document(); // Document | 
let assetFile = "/path/to/file"; // File | 
apiInstance.putAsset(document, assetFile, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **document** | [**Document**](Document.md)|  | 
 **assetFile** | **File**|  | 

### Return type

[**Document**](Document.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: multipart/form-data
- **Accept**: application/json-patch+json, application/json

