# JansConfigApi.Fido2ConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getPropertiesFido2**](Fido2ConfigurationApi.md#getPropertiesFido2) | **GET** /fido2/fido2-config | Gets Jans Authorization Server Fido2 configuration properties
[**putPropertiesFido2**](Fido2ConfigurationApi.md#putPropertiesFido2) | **PUT** /fido2/fido2-config | Updates Fido2 configuration properties



## getPropertiesFido2

> AppConfiguration1 getPropertiesFido2()

Gets Jans Authorization Server Fido2 configuration properties

Gets Jans Authorization Server Fido2 configuration properties

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.Fido2ConfigurationApi();
apiInstance.getPropertiesFido2((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**AppConfiguration1**](AppConfiguration1.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## putPropertiesFido2

> AppConfiguration1 putPropertiesFido2(opts)

Updates Fido2 configuration properties

Updates Fido2 configuration properties

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.Fido2ConfigurationApi();
let opts = {
  'appConfiguration1': new JansConfigApi.AppConfiguration1() // AppConfiguration1 | Fido2Config
};
apiInstance.putPropertiesFido2(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **appConfiguration1** | [**AppConfiguration1**](AppConfiguration1.md)| Fido2Config | [optional] 

### Return type

[**AppConfiguration1**](AppConfiguration1.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

