# JansConfigApi.CacheConfigurationInMemoryApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getConfigCacheInMemory**](CacheConfigurationInMemoryApi.md#getConfigCacheInMemory) | **GET** /api/v1/config/cache/in-memory | Returns in-Memory cache configuration.
[**patchConfigCacheInMemory**](CacheConfigurationInMemoryApi.md#patchConfigCacheInMemory) | **PATCH** /api/v1/config/cache/in-memory | Patch In-Memory cache configuration.
[**putConfigCacheInMemory**](CacheConfigurationInMemoryApi.md#putConfigCacheInMemory) | **PUT** /api/v1/config/cache/in-memory | Updates in-Memory cache configuration.



## getConfigCacheInMemory

> InMemoryConfiguration getConfigCacheInMemory()

Returns in-Memory cache configuration.

Returns in-Memory cache configuration.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationInMemoryApi();
apiInstance.getConfigCacheInMemory((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**InMemoryConfiguration**](InMemoryConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchConfigCacheInMemory

> InMemoryConfiguration patchConfigCacheInMemory(opts)

Patch In-Memory cache configuration.

Patch In-Memory cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationInMemoryApi();
let opts = {
  'requestBody': [{ "op": "replace", "path": "/defaultPutExpiration", "value":80}] 
 // [Object] | String representing patch-document.
};
apiInstance.patchConfigCacheInMemory(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**InMemoryConfiguration**](InMemoryConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putConfigCacheInMemory

> InMemoryConfiguration putConfigCacheInMemory(opts)

Updates in-Memory cache configuration.

Updates in-Memory cache configuration

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.CacheConfigurationInMemoryApi();
let opts = {
  'inMemoryConfiguration': {
    "defaultPutExpiration": 60
}
 // InMemoryConfiguration | inMemoryConfiguration object
};
apiInstance.putConfigCacheInMemory(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **inMemoryConfiguration** | [**InMemoryConfiguration**](InMemoryConfiguration.md)| inMemoryConfiguration object | [optional] 

### Return type

[**InMemoryConfiguration**](InMemoryConfiguration.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

