/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';
import KeyValuePair from './KeyValuePair';

/**
 * The AppConfigResponse model module.
 * @module model/AppConfigResponse
 * @version OAS Version
 */
class AppConfigResponse {
    /**
     * Constructs a new <code>AppConfigResponse</code>.
     * @alias module:model/AppConfigResponse
     */
    constructor() { 
        
        AppConfigResponse.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>AppConfigResponse</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/AppConfigResponse} obj Optional instance to populate.
     * @return {module:model/AppConfigResponse} The populated <code>AppConfigResponse</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new AppConfigResponse();

            if (data.hasOwnProperty('authServerHost')) {
                obj['authServerHost'] = ApiClient.convertToType(data['authServerHost'], 'String');
            }
            if (data.hasOwnProperty('authzBaseUrl')) {
                obj['authzBaseUrl'] = ApiClient.convertToType(data['authzBaseUrl'], 'String');
            }
            if (data.hasOwnProperty('clientId')) {
                obj['clientId'] = ApiClient.convertToType(data['clientId'], 'String');
            }
            if (data.hasOwnProperty('responseType')) {
                obj['responseType'] = ApiClient.convertToType(data['responseType'], 'String');
            }
            if (data.hasOwnProperty('scope')) {
                obj['scope'] = ApiClient.convertToType(data['scope'], 'String');
            }
            if (data.hasOwnProperty('redirectUrl')) {
                obj['redirectUrl'] = ApiClient.convertToType(data['redirectUrl'], 'String');
            }
            if (data.hasOwnProperty('acrValues')) {
                obj['acrValues'] = ApiClient.convertToType(data['acrValues'], 'String');
            }
            if (data.hasOwnProperty('frontChannelLogoutUrl')) {
                obj['frontChannelLogoutUrl'] = ApiClient.convertToType(data['frontChannelLogoutUrl'], 'String');
            }
            if (data.hasOwnProperty('postLogoutRedirectUri')) {
                obj['postLogoutRedirectUri'] = ApiClient.convertToType(data['postLogoutRedirectUri'], 'String');
            }
            if (data.hasOwnProperty('endSessionEndpoint')) {
                obj['endSessionEndpoint'] = ApiClient.convertToType(data['endSessionEndpoint'], 'String');
            }
            if (data.hasOwnProperty('sessionTimeoutInMins')) {
                obj['sessionTimeoutInMins'] = ApiClient.convertToType(data['sessionTimeoutInMins'], 'Number');
            }
            if (data.hasOwnProperty('allowSmtpKeystoreEdit')) {
                obj['allowSmtpKeystoreEdit'] = ApiClient.convertToType(data['allowSmtpKeystoreEdit'], 'Boolean');
            }
            if (data.hasOwnProperty('additionalParameters')) {
                obj['additionalParameters'] = ApiClient.convertToType(data['additionalParameters'], [KeyValuePair]);
            }
            if (data.hasOwnProperty('cedarlingLogType')) {
                obj['cedarlingLogType'] = ApiClient.convertToType(data['cedarlingLogType'], 'String');
            }
            if (data.hasOwnProperty('auiPolicyStoreUrl')) {
                obj['auiPolicyStoreUrl'] = ApiClient.convertToType(data['auiPolicyStoreUrl'], 'String');
            }
            if (data.hasOwnProperty('auiDefaultPolicyStorePath')) {
                obj['auiDefaultPolicyStorePath'] = ApiClient.convertToType(data['auiDefaultPolicyStorePath'], 'String');
            }
            if (data.hasOwnProperty('useRemotePolicyStore')) {
                obj['useRemotePolicyStore'] = ApiClient.convertToType(data['useRemotePolicyStore'], 'Boolean');
            }
        }
        return obj;
    }


}

/**
 * Auth Server host
 * @member {String} authServerHost
 */
AppConfigResponse.prototype['authServerHost'] = undefined;

/**
 * Authorization base URL
 * @member {String} authzBaseUrl
 */
AppConfigResponse.prototype['authzBaseUrl'] = undefined;

/**
 * OIDC Client ID
 * @member {String} clientId
 */
AppConfigResponse.prototype['clientId'] = undefined;

/**
 * OIDC Client Secret
 * @member {String} responseType
 */
AppConfigResponse.prototype['responseType'] = undefined;

/**
 * Scope
 * @member {String} scope
 */
AppConfigResponse.prototype['scope'] = undefined;

/**
 * Redirect URL
 * @member {String} redirectUrl
 */
AppConfigResponse.prototype['redirectUrl'] = undefined;

/**
 * ACR Value
 * @member {String} acrValues
 */
AppConfigResponse.prototype['acrValues'] = undefined;

/**
 * Front Channel Logout URL
 * @member {String} frontChannelLogoutUrl
 */
AppConfigResponse.prototype['frontChannelLogoutUrl'] = undefined;

/**
 * Post Logout Redirect URL
 * @member {String} postLogoutRedirectUri
 */
AppConfigResponse.prototype['postLogoutRedirectUri'] = undefined;

/**
 * End Session Endpoint
 * @member {String} endSessionEndpoint
 */
AppConfigResponse.prototype['endSessionEndpoint'] = undefined;

/**
 * Admin UI Session Timeout
 * @member {Number} sessionTimeoutInMins
 */
AppConfigResponse.prototype['sessionTimeoutInMins'] = undefined;

/**
 * Admin UI allow SMTP Keystore Edit
 * @member {Boolean} allowSmtpKeystoreEdit
 */
AppConfigResponse.prototype['allowSmtpKeystoreEdit'] = undefined;

/**
 * Additional Authentication Parameters
 * @member {Array.<module:model/KeyValuePair>} additionalParameters
 */
AppConfigResponse.prototype['additionalParameters'] = undefined;

/**
 * Cedarling log type
 * @member {module:model/AppConfigResponse.CedarlingLogTypeEnum} cedarlingLogType
 */
AppConfigResponse.prototype['cedarlingLogType'] = undefined;

/**
 * Admin UI Policy Store URL
 * @member {String} auiPolicyStoreUrl
 */
AppConfigResponse.prototype['auiPolicyStoreUrl'] = undefined;

/**
 * Admin UI Default Policy Store path
 * @member {String} auiDefaultPolicyStorePath
 */
AppConfigResponse.prototype['auiDefaultPolicyStorePath'] = undefined;

/**
 * Use remote Policy Store. If set to false then Admin UI will use default Policy Store.
 * @member {Boolean} useRemotePolicyStore
 */
AppConfigResponse.prototype['useRemotePolicyStore'] = undefined;





/**
 * Allowed values for the <code>cedarlingLogType</code> property.
 * @enum {String}
 * @readonly
 */
AppConfigResponse['CedarlingLogTypeEnum'] = {

    /**
     * value: "off"
     * @const
     */
    "off": "off",

    /**
     * value: "std_out"
     * @const
     */
    "std_out": "std_out"
};



export default AppConfigResponse;

