# JansConfigApi.KCLinkConfigurationApi

All URIs are relative to *https://jans.local.io*

Method | HTTP request | Description
------------- | ------------- | -------------
[**getKcLinkProperties**](KCLinkConfigurationApi.md#getKcLinkProperties) | **GET** /kc-link/kcLinkConfig | Gets KC Link configuration properties
[**patchKcLinkProperties**](KCLinkConfigurationApi.md#patchKcLinkProperties) | **PATCH** /kc-link/kcLinkConfig | Partially modifies KC Link configuration properties.
[**putKcLinkProperties**](KCLinkConfigurationApi.md#putKcLinkProperties) | **PUT** /kc-link/kcLinkConfig | Update KC Link configuration properties



## getKcLinkProperties

> AppConfiguration4 getKcLinkProperties()

Gets KC Link configuration properties

Gets KC Link configuration properties

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.KCLinkConfigurationApi();
apiInstance.getKcLinkProperties((error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**AppConfiguration4**](AppConfiguration4.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json


## patchKcLinkProperties

> AppConfiguration4 patchKcLinkProperties(opts)

Partially modifies KC Link configuration properties.

Partially modifies KC Link configuration properties.

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.KCLinkConfigurationApi();
let opts = {
  'requestBody':  // [Object] | String representing patch-document.
};
apiInstance.patchKcLinkProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **requestBody** | [**[Object]**](Object.md)| String representing patch-document. | [optional] 

### Return type

[**AppConfiguration4**](AppConfiguration4.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json-patch+json
- **Accept**: application/json


## putKcLinkProperties

> AppConfiguration4 putKcLinkProperties(opts)

Update KC Link configuration properties

Update KC Link configuration properties

### Example

```javascript
import JansConfigApi from 'jans_config_api';
let defaultClient = JansConfigApi.ApiClient.instance;
// Configure OAuth2 access token for authorization: oauth2
let oauth2 = defaultClient.authentications['oauth2'];
oauth2.accessToken = 'YOUR ACCESS TOKEN';

let apiInstance = new JansConfigApi.KCLinkConfigurationApi();
let opts = {
  'appConfiguration4':  // AppConfiguration4 | GluuAttribute object
};
apiInstance.putKcLinkProperties(opts, (error, data, response) => {
  if (error) {
    console.error(error);
  } else {
    console.log('API called successfully. Returned data: ' + data);
  }
});
```

### Parameters


Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **appConfiguration4** | [**AppConfiguration4**](AppConfiguration4.md)| GluuAttribute object | [optional] 

### Return type

[**AppConfiguration4**](AppConfiguration4.md)

### Authorization

[oauth2](../README.md#oauth2)

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

