"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _KeyValuePair = _interopRequireDefault(require("./KeyValuePair"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
 * The AppConfigResponse model module.
 * @module model/AppConfigResponse
 * @version OAS Version
 */
var AppConfigResponse = /*#__PURE__*/function () {
  /**
   * Constructs a new <code>AppConfigResponse</code>.
   * @alias module:model/AppConfigResponse
   */
  function AppConfigResponse() {
    _classCallCheck(this, AppConfigResponse);
    AppConfigResponse.initialize(this);
  }

  /**
   * Initializes the fields of this object.
   * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
   * Only for internal use.
   */
  return _createClass(AppConfigResponse, null, [{
    key: "initialize",
    value: function initialize(obj) {}

    /**
     * Constructs a <code>AppConfigResponse</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/AppConfigResponse} obj Optional instance to populate.
     * @return {module:model/AppConfigResponse} The populated <code>AppConfigResponse</code> instance.
     */
  }, {
    key: "constructFromObject",
    value: function constructFromObject(data, obj) {
      if (data) {
        obj = obj || new AppConfigResponse();
        if (data.hasOwnProperty('authServerHost')) {
          obj['authServerHost'] = _ApiClient["default"].convertToType(data['authServerHost'], 'String');
        }
        if (data.hasOwnProperty('authzBaseUrl')) {
          obj['authzBaseUrl'] = _ApiClient["default"].convertToType(data['authzBaseUrl'], 'String');
        }
        if (data.hasOwnProperty('clientId')) {
          obj['clientId'] = _ApiClient["default"].convertToType(data['clientId'], 'String');
        }
        if (data.hasOwnProperty('responseType')) {
          obj['responseType'] = _ApiClient["default"].convertToType(data['responseType'], 'String');
        }
        if (data.hasOwnProperty('scope')) {
          obj['scope'] = _ApiClient["default"].convertToType(data['scope'], 'String');
        }
        if (data.hasOwnProperty('redirectUrl')) {
          obj['redirectUrl'] = _ApiClient["default"].convertToType(data['redirectUrl'], 'String');
        }
        if (data.hasOwnProperty('acrValues')) {
          obj['acrValues'] = _ApiClient["default"].convertToType(data['acrValues'], 'String');
        }
        if (data.hasOwnProperty('frontChannelLogoutUrl')) {
          obj['frontChannelLogoutUrl'] = _ApiClient["default"].convertToType(data['frontChannelLogoutUrl'], 'String');
        }
        if (data.hasOwnProperty('postLogoutRedirectUri')) {
          obj['postLogoutRedirectUri'] = _ApiClient["default"].convertToType(data['postLogoutRedirectUri'], 'String');
        }
        if (data.hasOwnProperty('endSessionEndpoint')) {
          obj['endSessionEndpoint'] = _ApiClient["default"].convertToType(data['endSessionEndpoint'], 'String');
        }
        if (data.hasOwnProperty('sessionTimeoutInMins')) {
          obj['sessionTimeoutInMins'] = _ApiClient["default"].convertToType(data['sessionTimeoutInMins'], 'Number');
        }
        if (data.hasOwnProperty('allowSmtpKeystoreEdit')) {
          obj['allowSmtpKeystoreEdit'] = _ApiClient["default"].convertToType(data['allowSmtpKeystoreEdit'], 'Boolean');
        }
        if (data.hasOwnProperty('additionalParameters')) {
          obj['additionalParameters'] = _ApiClient["default"].convertToType(data['additionalParameters'], [_KeyValuePair["default"]]);
        }
        if (data.hasOwnProperty('cedarlingLogType')) {
          obj['cedarlingLogType'] = _ApiClient["default"].convertToType(data['cedarlingLogType'], 'String');
        }
        if (data.hasOwnProperty('auiPolicyStoreUrl')) {
          obj['auiPolicyStoreUrl'] = _ApiClient["default"].convertToType(data['auiPolicyStoreUrl'], 'String');
        }
        if (data.hasOwnProperty('auiDefaultPolicyStorePath')) {
          obj['auiDefaultPolicyStorePath'] = _ApiClient["default"].convertToType(data['auiDefaultPolicyStorePath'], 'String');
        }
        if (data.hasOwnProperty('useRemotePolicyStore')) {
          obj['useRemotePolicyStore'] = _ApiClient["default"].convertToType(data['useRemotePolicyStore'], 'Boolean');
        }
      }
      return obj;
    }
  }]);
}();
/**
 * Auth Server host
 * @member {String} authServerHost
 */
AppConfigResponse.prototype['authServerHost'] = undefined;

/**
 * Authorization base URL
 * @member {String} authzBaseUrl
 */
AppConfigResponse.prototype['authzBaseUrl'] = undefined;

/**
 * OIDC Client ID
 * @member {String} clientId
 */
AppConfigResponse.prototype['clientId'] = undefined;

/**
 * OIDC Client Secret
 * @member {String} responseType
 */
AppConfigResponse.prototype['responseType'] = undefined;

/**
 * Scope
 * @member {String} scope
 */
AppConfigResponse.prototype['scope'] = undefined;

/**
 * Redirect URL
 * @member {String} redirectUrl
 */
AppConfigResponse.prototype['redirectUrl'] = undefined;

/**
 * ACR Value
 * @member {String} acrValues
 */
AppConfigResponse.prototype['acrValues'] = undefined;

/**
 * Front Channel Logout URL
 * @member {String} frontChannelLogoutUrl
 */
AppConfigResponse.prototype['frontChannelLogoutUrl'] = undefined;

/**
 * Post Logout Redirect URL
 * @member {String} postLogoutRedirectUri
 */
AppConfigResponse.prototype['postLogoutRedirectUri'] = undefined;

/**
 * End Session Endpoint
 * @member {String} endSessionEndpoint
 */
AppConfigResponse.prototype['endSessionEndpoint'] = undefined;

/**
 * Admin UI Session Timeout
 * @member {Number} sessionTimeoutInMins
 */
AppConfigResponse.prototype['sessionTimeoutInMins'] = undefined;

/**
 * Admin UI allow SMTP Keystore Edit
 * @member {Boolean} allowSmtpKeystoreEdit
 */
AppConfigResponse.prototype['allowSmtpKeystoreEdit'] = undefined;

/**
 * Additional Authentication Parameters
 * @member {Array.<module:model/KeyValuePair>} additionalParameters
 */
AppConfigResponse.prototype['additionalParameters'] = undefined;

/**
 * Cedarling log type
 * @member {module:model/AppConfigResponse.CedarlingLogTypeEnum} cedarlingLogType
 */
AppConfigResponse.prototype['cedarlingLogType'] = undefined;

/**
 * Admin UI Policy Store URL
 * @member {String} auiPolicyStoreUrl
 */
AppConfigResponse.prototype['auiPolicyStoreUrl'] = undefined;

/**
 * Admin UI Default Policy Store path
 * @member {String} auiDefaultPolicyStorePath
 */
AppConfigResponse.prototype['auiDefaultPolicyStorePath'] = undefined;

/**
 * Use remote Policy Store. If set to false then Admin UI will use default Policy Store.
 * @member {Boolean} useRemotePolicyStore
 */
AppConfigResponse.prototype['useRemotePolicyStore'] = undefined;

/**
 * Allowed values for the <code>cedarlingLogType</code> property.
 * @enum {String}
 * @readonly
 */
AppConfigResponse['CedarlingLogTypeEnum'] = {
  /**
   * value: "off"
   * @const
   */
  "off": "off",
  /**
   * value: "std_out"
   * @const
   */
  "std_out": "std_out"
};
var _default = exports["default"] = AppConfigResponse;