"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _SamlAppConfiguration = _interopRequireDefault(require("../model/SamlAppConfiguration"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* SAMLConfiguration service.
* @module api/SAMLConfigurationApi
* @version OAS Version
*/
var SAMLConfigurationApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new SAMLConfigurationApi. 
  * @alias module:api/SAMLConfigurationApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function SAMLConfigurationApi(apiClient) {
    _classCallCheck(this, SAMLConfigurationApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the getSamlProperties operation.
   * @callback module:api/SAMLConfigurationApi~getSamlPropertiesCallback
   * @param {String} error Error message, if any.
   * @param {module:model/SamlAppConfiguration} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Gets SAML configuration properties
   * Gets SAML configuration properties
   * @param {module:api/SAMLConfigurationApi~getSamlPropertiesCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link module:model/SamlAppConfiguration}
   */
  return _createClass(SAMLConfigurationApi, [{
    key: "getSamlProperties",
    value: function getSamlProperties(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _SamlAppConfiguration["default"];
      return this.apiClient.callApi('/kc/samlConfig', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchSamlProperties operation.
     * @callback module:api/SAMLConfigurationApi~patchSamlPropertiesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SamlAppConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Partially modifies SAML configuration properties.
     * Partially modifies SAML Configuration properties.
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/SAMLConfigurationApi~patchSamlPropertiesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SamlAppConfiguration}
     */
  }, {
    key: "patchSamlProperties",
    value: function patchSamlProperties(opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _SamlAppConfiguration["default"];
      return this.apiClient.callApi('/kc/samlConfig', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putSamlProperties operation.
     * @callback module:api/SAMLConfigurationApi~putSamlPropertiesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/SamlAppConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Update SAML configuration properties
     * Update SAML configuration properties
     * @param {Object} opts Optional parameters
     * @param {module:model/SamlAppConfiguration} opts.samlAppConfiguration GluuAttribute object
     * @param {module:api/SAMLConfigurationApi~putSamlPropertiesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/SamlAppConfiguration}
     */
  }, {
    key: "putSamlProperties",
    value: function putSamlProperties(opts, callback) {
      opts = opts || {};
      var postBody = opts['samlAppConfiguration'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _SamlAppConfiguration["default"];
      return this.apiClient.callApi('/kc/samlConfig', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();