"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _utils = require("../../utils");
var propTypes = {
  children: _propTypes["default"].string.isRequired,
  highlightClassName: _propTypes["default"].string,
  search: _propTypes["default"].string.isRequired
};
/**
 * Stripped-down version of https://github.com/helior/react-highlighter
 *
 * Results are already filtered by the time the component is used internally so
 * we can safely ignore case and diacritical marks for the purposes of matching.
 */
var Highlighter = function Highlighter(_ref) {
  var children = _ref.children,
    _ref$highlightClassNa = _ref.highlightClassName,
    highlightClassName = _ref$highlightClassNa === void 0 ? 'rbt-highlight-text' : _ref$highlightClassNa,
    search = _ref.search;
  if (!search || !children) {
    return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, children);
  }
  var matchCount = 0;
  var remaining = children;
  var highlighterChildren = [];
  while (remaining) {
    var bounds = (0, _utils.getMatchBounds)(remaining, search);

    // No match anywhere in the remaining string, stop.
    if (!bounds) {
      highlighterChildren.push(remaining);
      break;
    }

    // Capture the string that leads up to a match.
    var nonMatch = remaining.slice(0, bounds.start);
    if (nonMatch) {
      highlighterChildren.push(nonMatch);
    }

    // Capture the matching string.
    var match = remaining.slice(bounds.start, bounds.end);
    highlighterChildren.push( /*#__PURE__*/_react["default"].createElement("mark", {
      className: highlightClassName,
      key: matchCount
    }, match));
    matchCount += 1;

    // And if there's anything left over, continue the loop.
    remaining = remaining.slice(bounds.end);
  }
  return /*#__PURE__*/_react["default"].createElement(_react["default"].Fragment, null, highlighterChildren);
};
Highlighter.propTypes = propTypes;
var _default = exports["default"] = Highlighter;