import PropTypes from 'prop-types';
import { HTMLProps } from 'react';
import type { Size } from '../../types';
export interface ClearButtonProps extends Omit<HTMLProps<HTMLButtonElement>, 'size'> {
    label?: string;
    size?: Size;
}
declare const ClearButton: {
    ({ className, label, onClick, onKeyDown, size, ...props }: ClearButtonProps): JSX.Element;
    propTypes: {
        label: PropTypes.Requireable<string>;
        onClick: PropTypes.Requireable<(...args: any[]) => any>;
        onKeyDown: PropTypes.Requireable<(...args: any[]) => any>;
        size: PropTypes.Requireable<"lg" | "sm">;
    };
};
export default ClearButton;
