/* eslint-disable @typescript-eslint/ban-types */
/* eslint-disable @typescript-eslint/no-explicit-any */
import { objectKeys } from "./tools/objectKeys";
export function mergeClasses(classesFromUseStyles, classesOverrides, cx) {
    //NOTE: We use this test to be resilient in case classesOverrides is not of the expected type.
    if (!(classesOverrides instanceof Object)) {
        return classesFromUseStyles;
    }
    const out = {};
    objectKeys(classesFromUseStyles).forEach(ruleName => (out[ruleName] = cx(classesFromUseStyles[ruleName], classesOverrides[ruleName])));
    objectKeys(classesOverrides).forEach(ruleName => {
        if (ruleName in classesFromUseStyles) {
            return;
        }
        const className = classesOverrides[ruleName];
        //...Same here, that why we don't do className === undefined
        if (typeof className !== "string") {
            return;
        }
        out[ruleName] = className;
    });
    return out;
}
