import { axe } from 'jest-axe';
import React, { ReactNode } from 'react';
import { Meta } from '@storybook/react';
import { RenderResult } from '@testing-library/react';
import { TypeaheadContextType } from '../core/Context';
export { axe };
export * from '@storybook/testing-react';
export * from '@testing-library/react';
export { default as userEvent } from '@testing-library/user-event';
export declare function noop(): void;
interface StoriesImport {
    default: Meta;
}
interface TestOptions {
    getElement?: (wrapper: RenderResult) => Promise<ChildNode | null> | ChildNode | null;
}
export declare function generateSnapshots(stories: StoriesImport, { getElement }?: TestOptions): void;
interface HintProviderProps extends Partial<TypeaheadContextType> {
    children?: ReactNode;
}
export declare const HintProvider: ({ children, ...context }: HintProviderProps) => React.JSX.Element;
export declare function getHint(container: HTMLElement): Element;
export declare function findInput(multiple?: boolean): Promise<HTMLElement>;
export declare function getInput(): HTMLInputElement;
export declare function findItems(): Promise<HTMLElement[]>;
export declare function getItems(): HTMLElement[];
export declare function findMenu(): Promise<HTMLElement>;
export declare function getMenu(): HTMLElement | null;
export declare function findPaginator(): Promise<HTMLElement>;
export declare function getTokens(container: HTMLElement): HTMLCollectionOf<Element>;
export declare function waitForOverlay(): Promise<void>;
