import getOptionLabel from './getOptionLabel';
import { isFunction } from './nodash';
function addCustomOption(results, props) {
    const { allowNew, labelKey, text } = props;
    if (!allowNew || !text.trim()) {
        return false;
    }
    if (isFunction(allowNew)) {
        return allowNew(results, props);
    }
    return !results.some((o) => getOptionLabel(o, labelKey) === text);
}
export default addCustomOption;
