import React, { ChangeEvent, ComponentType, ReactNode } from 'react';
import Typeahead from '../core/Typeahead';
import { TypeaheadComponentProps } from '../components/Typeahead';
import type { Option } from '../types';
export interface UseAsyncProps extends TypeaheadComponentProps {
    delay?: number;
    isLoading: boolean;
    onSearch: (query: string) => void;
    promptText?: ReactNode;
    searchText?: ReactNode;
    useCache?: boolean;
}
export declare function useAsync(props: UseAsyncProps): {
    allowNew: boolean | ((options: Option[], state: import("../types").TypeaheadPropsAndState) => boolean) | undefined;
    emptyLabel: React.ReactNode;
    isLoading: boolean;
    minLength: number;
    onInputChange: (query: string, e: ChangeEvent<HTMLInputElement>) => void;
    options: Option[];
    align?: "justify" | "left" | "right" | undefined;
    className?: string | undefined;
    clearButton?: boolean | undefined;
    disabled?: boolean | undefined;
    dropup?: boolean | undefined;
    flip?: boolean | undefined;
    instanceRef?: React.Ref<Typeahead> | undefined;
    isInvalid?: boolean | undefined;
    isValid?: boolean | undefined;
    maxHeight?: string | undefined;
    newSelectionPrefix?: React.ReactNode;
    paginationText?: React.ReactNode;
    placeholder?: string | undefined;
    positionFixed?: boolean | undefined;
    renderInput?: ((inputProps: import("../types").TypeaheadInputProps, props: import("../types").TypeaheadManagerChildProps) => JSX.Element) | undefined;
    renderMenu?: ((results: Option[], menuProps: import("../components/Typeahead").RenderMenuProps, state: import("../types").TypeaheadManagerChildProps) => JSX.Element) | undefined;
    renderMenuItemChildren?: import("..").RenderMenuItemChildren | undefined;
    renderToken?: import("../types").RenderToken | undefined;
    size?: "lg" | "sm" | undefined;
    style?: React.CSSProperties | undefined;
    autoFocus?: boolean | undefined;
    caseSensitive?: boolean | undefined;
    children?: import("../types").TypeaheadChildren;
    defaultInputValue?: string | undefined;
    defaultOpen?: boolean | undefined;
    defaultSelected?: Option[] | undefined;
    filterBy?: import("../types").FilterByCallback | string[] | undefined;
    highlightOnlyResult?: boolean | undefined;
    id?: string | undefined;
    ignoreDiacritics?: boolean | undefined;
    inputProps?: import("../types").InputProps | undefined;
    labelKey?: import("../types").LabelKey | undefined;
    maxResults?: number | undefined;
    multiple?: boolean | undefined;
    onBlur?: React.FocusEventHandler<HTMLInputElement> | undefined;
    onChange?: ((selected: Option[]) => void) | undefined;
    onFocus?: ((event: React.SyntheticEvent<HTMLInputElement, Event>) => void) | undefined;
    onKeyDown?: React.KeyboardEventHandler<HTMLInputElement> | undefined;
    onMenuToggle?: ((isOpen: boolean) => void) | undefined;
    onPaginate?: ((event: import("../types").SelectEvent<HTMLElement>, shownResults: number) => void) | undefined;
    open?: boolean | undefined;
    paginate?: boolean | undefined;
    selected?: Option[] | undefined;
    selectHint?: import("../types").SelectHint | undefined;
};
export declare function withAsync<T extends UseAsyncProps = UseAsyncProps>(Component: ComponentType<T>): React.ForwardRefExoticComponent<React.PropsWithoutRef<T> & React.RefAttributes<Typeahead>>;
