import _objectWithoutProperties from "@babel/runtime/helpers/esm/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/esm/extends";
var _excluded = ["children", "className", "slots", "slotProps", "isNextDisabled", "isNextHidden", "onGoToNext", "nextLabel", "isPreviousDisabled", "isPreviousHidden", "onGoToPrevious", "previousLabel"],
  _excluded2 = ["ownerState"],
  _excluded3 = ["ownerState"];
import * as React from 'react';
import clsx from 'clsx';
import Typography from '@mui/material/Typography';
import { useTheme, styled, useThemeProps } from '@mui/material/styles';
import { unstable_composeClasses as composeClasses } from '@mui/utils';
import { useSlotProps } from '@mui/base/utils';
import IconButton from '@mui/material/IconButton';
import { ArrowLeftIcon, ArrowRightIcon } from '../../../icons';
import { getPickersArrowSwitcherUtilityClass } from './pickersArrowSwitcherClasses';
import { jsx as _jsx } from "react/jsx-runtime";
import { jsxs as _jsxs } from "react/jsx-runtime";
var PickersArrowSwitcherRoot = styled('div', {
  name: 'MuiPickersArrowSwitcher',
  slot: 'Root',
  overridesResolver: function overridesResolver(props, styles) {
    return styles.root;
  }
})({
  display: 'flex'
});
var PickersArrowSwitcherSpacer = styled('div', {
  name: 'MuiPickersArrowSwitcher',
  slot: 'Spacer',
  overridesResolver: function overridesResolver(props, styles) {
    return styles.spacer;
  }
})(function (_ref) {
  var theme = _ref.theme;
  return {
    width: theme.spacing(3)
  };
});
var PickersArrowSwitcherButton = styled(IconButton, {
  name: 'MuiPickersArrowSwitcher',
  slot: 'Button',
  overridesResolver: function overridesResolver(props, styles) {
    return styles.button;
  }
})(function (_ref2) {
  var ownerState = _ref2.ownerState;
  return _extends({}, ownerState.hidden && {
    visibility: 'hidden'
  });
});
var useUtilityClasses = function useUtilityClasses(ownerState) {
  var classes = ownerState.classes;
  var slots = {
    root: ['root'],
    spacer: ['spacer'],
    button: ['button']
  };
  return composeClasses(slots, getPickersArrowSwitcherUtilityClass, classes);
};
export var PickersArrowSwitcher = /*#__PURE__*/React.forwardRef(function PickersArrowSwitcher(inProps, ref) {
  var _slots$previousIconBu, _slots$nextIconButton, _slots$leftArrowIcon, _slots$rightArrowIcon;
  var theme = useTheme();
  var isRTL = theme.direction === 'rtl';
  var props = useThemeProps({
    props: inProps,
    name: 'MuiPickersArrowSwitcher'
  });
  var children = props.children,
    className = props.className,
    slots = props.slots,
    slotProps = props.slotProps,
    isNextDisabled = props.isNextDisabled,
    isNextHidden = props.isNextHidden,
    onGoToNext = props.onGoToNext,
    nextLabel = props.nextLabel,
    isPreviousDisabled = props.isPreviousDisabled,
    isPreviousHidden = props.isPreviousHidden,
    onGoToPrevious = props.onGoToPrevious,
    previousLabel = props.previousLabel,
    other = _objectWithoutProperties(props, _excluded);
  var ownerState = props;
  var classes = useUtilityClasses(ownerState);
  var nextProps = {
    isDisabled: isNextDisabled,
    isHidden: isNextHidden,
    goTo: onGoToNext,
    label: nextLabel
  };
  var previousProps = {
    isDisabled: isPreviousDisabled,
    isHidden: isPreviousHidden,
    goTo: onGoToPrevious,
    label: previousLabel
  };
  var PreviousIconButton = (_slots$previousIconBu = slots == null ? void 0 : slots.previousIconButton) != null ? _slots$previousIconBu : PickersArrowSwitcherButton;
  var previousIconButtonProps = useSlotProps({
    elementType: PreviousIconButton,
    externalSlotProps: slotProps == null ? void 0 : slotProps.previousIconButton,
    additionalProps: {
      size: 'medium',
      title: previousProps.label,
      'aria-label': previousProps.label,
      disabled: previousProps.isDisabled,
      edge: 'end',
      onClick: previousProps.goTo
    },
    ownerState: _extends({}, ownerState, {
      hidden: previousProps.isHidden
    }),
    className: classes.button
  });
  var NextIconButton = (_slots$nextIconButton = slots == null ? void 0 : slots.nextIconButton) != null ? _slots$nextIconButton : PickersArrowSwitcherButton;
  var nextIconButtonProps = useSlotProps({
    elementType: NextIconButton,
    externalSlotProps: slotProps == null ? void 0 : slotProps.nextIconButton,
    additionalProps: {
      size: 'medium',
      title: nextProps.label,
      'aria-label': nextProps.label,
      disabled: nextProps.isDisabled,
      edge: 'start',
      onClick: nextProps.goTo
    },
    ownerState: _extends({}, ownerState, {
      hidden: nextProps.isHidden
    }),
    className: classes.button
  });
  var LeftArrowIcon = (_slots$leftArrowIcon = slots == null ? void 0 : slots.leftArrowIcon) != null ? _slots$leftArrowIcon : ArrowLeftIcon;
  // The spread is here to avoid this bug mui/material-ui#34056
  var _useSlotProps = useSlotProps({
      elementType: LeftArrowIcon,
      externalSlotProps: slotProps == null ? void 0 : slotProps.leftArrowIcon,
      additionalProps: {
        fontSize: 'inherit'
      },
      ownerState: undefined
    }),
    leftArrowIconOwnerState = _useSlotProps.ownerState,
    leftArrowIconProps = _objectWithoutProperties(_useSlotProps, _excluded2);
  var RightArrowIcon = (_slots$rightArrowIcon = slots == null ? void 0 : slots.rightArrowIcon) != null ? _slots$rightArrowIcon : ArrowRightIcon;
  // The spread is here to avoid this bug mui/material-ui#34056
  var _useSlotProps2 = useSlotProps({
      elementType: RightArrowIcon,
      externalSlotProps: slotProps == null ? void 0 : slotProps.rightArrowIcon,
      additionalProps: {
        fontSize: 'inherit'
      },
      ownerState: undefined
    }),
    rightArrowIconOwnerState = _useSlotProps2.ownerState,
    rightArrowIconProps = _objectWithoutProperties(_useSlotProps2, _excluded3);
  return /*#__PURE__*/_jsxs(PickersArrowSwitcherRoot, _extends({
    ref: ref,
    className: clsx(classes.root, className),
    ownerState: ownerState
  }, other, {
    children: [/*#__PURE__*/_jsx(PreviousIconButton, _extends({}, previousIconButtonProps, {
      children: isRTL ? /*#__PURE__*/_jsx(RightArrowIcon, _extends({}, rightArrowIconProps)) : /*#__PURE__*/_jsx(LeftArrowIcon, _extends({}, leftArrowIconProps))
    })), children ? /*#__PURE__*/_jsx(Typography, {
      variant: "subtitle1",
      component: "span",
      children: children
    }) : /*#__PURE__*/_jsx(PickersArrowSwitcherSpacer, {
      className: classes.spacer,
      ownerState: ownerState
    }), /*#__PURE__*/_jsx(NextIconButton, _extends({}, nextIconButtonProps, {
      children: isRTL ? /*#__PURE__*/_jsx(LeftArrowIcon, _extends({}, leftArrowIconProps)) : /*#__PURE__*/_jsx(RightArrowIcon, _extends({}, rightArrowIconProps))
    }))]
  }));
});