"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _styles = require("@mui/material/styles");
var _store = require("../../store");
function OverlayError(props) {
  var icons = (0, _store.useIconStore)();
  var theme = (0, _styles.useTheme)();
  return /*#__PURE__*/_react["default"].createElement("div", {
    ref: props.forwardedRef,
    style: {
      display: 'table',
      width: '100%',
      height: '100%',
      backgroundColor: theme.palette.background.paper,
      opacity: 0.7
    }
  }, /*#__PURE__*/_react["default"].createElement("div", {
    style: {
      display: 'table-cell',
      width: '100%',
      height: '100%',
      verticalAlign: 'middle',
      textAlign: 'center'
    }
  }, /*#__PURE__*/_react["default"].createElement("span", null, props.error.message), ' ', /*#__PURE__*/_react["default"].createElement(icons.Retry, {
    onClick: props.retry,
    style: {
      cursor: 'pointer',
      position: 'relative',
      top: 5
    }
  })));
}
OverlayError.propTypes = {
  error: _propTypes["default"].oneOfType([_propTypes["default"].object, _propTypes["default"].string]),
  retry: _propTypes["default"].func,
  theme: _propTypes["default"].any
};
var _default = exports["default"] = /*#__PURE__*/_react["default"].forwardRef(function OverlayErrorRef(props, ref) {
  return /*#__PURE__*/_react["default"].createElement(OverlayError, (0, _extends2["default"])({}, props, {
    forwardedRef: ref
  }));
});