import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { mapToCssModules, tagPropType } from './utils';

const propTypes = {
  /** Add active class to NavLink */
  active: PropTypes.bool,
  /** Add custom class */
  className: PropTypes.string,
  /** Change underlying component's CSS base class name */
  cssModule: PropTypes.object,
  /** Disable the link */
  disabled: PropTypes.bool,
  href: PropTypes.any,
  innerRef: PropTypes.oneOfType([
    PropTypes.object,
    PropTypes.func,
    PropTypes.string,
  ]),
  /** Function to be triggered on click */
  onClick: PropTypes.func,
  /** Set a custom element for this component */
  tag: tagPropType,
};

class NavLink extends React.Component {
  constructor(props) {
    super(props);

    this.onClick = this.onClick.bind(this);
  }

  onClick(e) {
    if (this.props.disabled) {
      e.preventDefault();
      return;
    }

    if (this.props.href === '#') {
      e.preventDefault();
    }

    if (this.props.onClick) {
      this.props.onClick(e);
    }
  }

  render() {
    let {
      className,
      cssModule,
      active,
      tag: Tag = 'a',
      innerRef,
      ...attributes
    } = this.props;

    const classes = mapToCssModules(
      classNames(className, 'nav-link', {
        disabled: attributes.disabled,
        active: active,
      }),
      cssModule,
    );

    return (
      <Tag
        {...attributes}
        ref={innerRef}
        onClick={this.onClick}
        className={classes}
      />
    );
  }
}

NavLink.propTypes = propTypes;

export default NavLink;
