"use strict";
/*
 * Copyright 2017 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
var revoke_token_request_1 = require("./revoke_token_request");
describe('Revoke Token Request tests', function () {
    var token = 'token';
    var request = new revoke_token_request_1.RevokeTokenRequest({ token: token });
    it('Basic Revoke Token Request Tests', function () {
        expect(request).not.toBeNull();
        expect(request.token).toBe(token);
    });
    it('To Json() and from Json() should work', function () {
        var json = JSON.parse(JSON.stringify(request.toJson()));
        expect(json).not.toBeNull();
        var newRequest = new revoke_token_request_1.RevokeTokenRequest(json);
        expect(newRequest).not.toBeNull();
        expect(newRequest.token).toBe(token);
    });
});
describe('Authenticated Revoke Token Request tests', function () {
    var token = 'token';
    var tokenTypeHint = 'refresh_token';
    var clientId = 'client_id';
    var clientSecret = 'client_secret';
    var request = new revoke_token_request_1.RevokeTokenRequest({
        token: token,
        token_type_hint: tokenTypeHint,
        client_id: clientId,
        client_secret: clientSecret
    });
    it('Basic Revoke Token Request Tests', function () {
        expect(request).not.toBeNull();
        expect(request.token).toBe(token);
        expect(request.tokenTypeHint).toBe(tokenTypeHint);
        expect(request.clientId).toBe(clientId);
        expect(request.clientSecret).toBe(clientSecret);
    });
    it('To Json() and from Json() should work', function () {
        var json = JSON.parse(JSON.stringify(request.toJson()));
        expect(json).not.toBeNull();
        var newRequest = new revoke_token_request_1.RevokeTokenRequest(json);
        expect(newRequest).not.toBeNull();
        expect(newRequest.token).toBe(token);
        expect(newRequest.tokenTypeHint).toBe(tokenTypeHint);
        expect(newRequest.clientId).toBe(clientId);
        expect(newRequest.clientSecret).toBe(clientSecret);
    });
});
//# sourceMappingURL=data:application/json;base64,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