import { Nfsv4Encoder } from './Nfsv4Encoder';
import { RpcMessageEncoder } from '../../rpc/RpcMessageEncoder';
import { RmRecordEncoder } from '../../rm/RmRecordEncoder';
import { Nfsv4Proc } from './constants';
import { RpcOpaqueAuth } from '../../rpc/messages';
import type * as msg from './messages';
import type { IWriter, IWriterGrowable } from '@jsonjoy.com/util/lib/buffers';
export declare class FullNfsv4Encoder<W extends IWriter & IWriterGrowable = IWriter & IWriterGrowable> {
    program: number;
    readonly writer: W;
    protected readonly nfsEncoder: Nfsv4Encoder<W>;
    protected readonly rpcEncoder: RpcMessageEncoder<W>;
    protected readonly rmEncoder: RmRecordEncoder<W>;
    constructor(program?: number, writer?: W);
    encodeCall(xid: number, proc: Nfsv4Proc, cred: RpcOpaqueAuth, verf: RpcOpaqueAuth, request: msg.Nfsv4CompoundRequest): Uint8Array;
    writeCall(xid: number, proc: Nfsv4Proc, cred: RpcOpaqueAuth, verf: RpcOpaqueAuth, request: msg.Nfsv4CompoundRequest): void;
    encodeAcceptedReply(xid: number, proc: Nfsv4Proc, verf: RpcOpaqueAuth, response: msg.Nfsv4CompoundResponse): Uint8Array;
    writeAcceptedReply(xid: number, proc: Nfsv4Proc, verf: RpcOpaqueAuth, response: msg.Nfsv4CompoundResponse): void;
    encodeRejectedReply(xid: number, rejectStat: number, mismatchInfo?: {
        low: number;
        high: number;
    }, authStat?: number): Uint8Array;
    writeRejectedReply(xid: number, rejectStat: number, mismatchInfo?: {
        low: number;
        high: number;
    }, authStat?: number): void;
    private writeRmHeader;
}
