"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _ApiClient = _interopRequireDefault(require("../ApiClient"));
var _GluuLdapConfiguration = _interopRequireDefault(require("../model/GluuLdapConfiguration"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { "default": e }; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _classCallCheck(a, n) { if (!(a instanceof n)) throw new TypeError("Cannot call a class as a function"); }
function _defineProperties(e, r) { for (var t = 0; t < r.length; t++) { var o = r[t]; o.enumerable = o.enumerable || !1, o.configurable = !0, "value" in o && (o.writable = !0), Object.defineProperty(e, _toPropertyKey(o.key), o); } }
function _createClass(e, r, t) { return r && _defineProperties(e.prototype, r), t && _defineProperties(e, t), Object.defineProperty(e, "prototype", { writable: !1 }), e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */
/**
* DatabaseLDAPConfiguration service.
* @module api/DatabaseLDAPConfigurationApi
* @version OAS Version
*/
var DatabaseLDAPConfigurationApi = exports["default"] = /*#__PURE__*/function () {
  /**
  * Constructs a new DatabaseLDAPConfigurationApi. 
  * @alias module:api/DatabaseLDAPConfigurationApi
  * @class
  * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
  * default to {@link module:ApiClient#instance} if unspecified.
  */
  function DatabaseLDAPConfigurationApi(apiClient) {
    _classCallCheck(this, DatabaseLDAPConfigurationApi);
    this.apiClient = apiClient || _ApiClient["default"].instance;
  }

  /**
   * Callback function to receive the result of the deleteConfigDatabaseLdapByName operation.
   * @callback module:api/DatabaseLDAPConfigurationApi~deleteConfigDatabaseLdapByNameCallback
   * @param {String} error Error message, if any.
   * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
   * @param {String} response The complete HTTP response.
   */

  /**
   * Deletes an LDAP configuration
   * Deletes an LDAP configuration
   * @param {String} name 
   * @param {module:api/DatabaseLDAPConfigurationApi~deleteConfigDatabaseLdapByNameCallback} callback The callback function, accepting three arguments: error, data, response
   * data is of type: {@link module:model/GluuLdapConfiguration}
   */
  return _createClass(DatabaseLDAPConfigurationApi, [{
    key: "deleteConfigDatabaseLdapByName",
    value: function deleteConfigDatabaseLdapByName(name, callback) {
      var postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling deleteConfigDatabaseLdapByName");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _GluuLdapConfiguration["default"];
      return this.apiClient.callApi('/api/v1/config/database/ldap/{name}', 'DELETE', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigDatabaseLdap operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~getConfigDatabaseLdapCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/GluuLdapConfiguration>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of existing LDAP configurations.
     * Gets list of existing LDAP configurations.
     * @param {module:api/DatabaseLDAPConfigurationApi~getConfigDatabaseLdapCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/GluuLdapConfiguration>}
     */
  }, {
    key: "getConfigDatabaseLdap",
    value: function getConfigDatabaseLdap(callback) {
      var postBody = null;
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = [_GluuLdapConfiguration["default"]];
      return this.apiClient.callApi('/api/v1/config/database/ldap', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the getConfigDatabaseLdapByName operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~getConfigDatabaseLdapByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets an LDAP configuration by name.
     * Gets an LDAP configuration by name.
     * @param {String} name Name of LDAP configuration
     * @param {module:api/DatabaseLDAPConfigurationApi~getConfigDatabaseLdapByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
  }, {
    key: "getConfigDatabaseLdapByName",
    value: function getConfigDatabaseLdapByName(name, callback) {
      var postBody = null;
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling getConfigDatabaseLdapByName");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = [];
      var accepts = ['application/json'];
      var returnType = _GluuLdapConfiguration["default"];
      return this.apiClient.callApi('/api/v1/config/database/ldap/{name}', 'GET', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the patchConfigDatabaseLdapByName operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~patchConfigDatabaseLdapByNameCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patches a LDAP configuration by name
     * Patches a LDAP configuration by name
     * @param {String} name Name of LDAP configuration
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody JsonPatch object
     * @param {module:api/DatabaseLDAPConfigurationApi~patchConfigDatabaseLdapByNameCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
  }, {
    key: "patchConfigDatabaseLdapByName",
    value: function patchConfigDatabaseLdapByName(name, opts, callback) {
      opts = opts || {};
      var postBody = opts['requestBody'];
      // verify the required parameter 'name' is set
      if (name === undefined || name === null) {
        throw new Error("Missing the required parameter 'name' when calling patchConfigDatabaseLdapByName");
      }
      var pathParams = {
        'name': name
      };
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json-patch+json'];
      var accepts = ['application/json'];
      var returnType = _GluuLdapConfiguration["default"];
      return this.apiClient.callApi('/api/v1/config/database/ldap/{name}', 'PATCH', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postConfigDatabaseLdap operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~postConfigDatabaseLdapCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Adds a new LDAP configuration
     * Adds a new LDAP configuration
     * @param {Object} opts Optional parameters
     * @param {module:model/GluuLdapConfiguration} opts.gluuLdapConfiguration GluuLdapConfiguration object
     * @param {module:api/DatabaseLDAPConfigurationApi~postConfigDatabaseLdapCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
  }, {
    key: "postConfigDatabaseLdap",
    value: function postConfigDatabaseLdap(opts, callback) {
      opts = opts || {};
      var postBody = opts['gluuLdapConfiguration'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _GluuLdapConfiguration["default"];
      return this.apiClient.callApi('/api/v1/config/database/ldap', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the postConfigDatabaseLdapTest operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~postConfigDatabaseLdapTestCallback
     * @param {String} error Error message, if any.
     * @param {Boolean} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Tests an LDAP configuration
     * Tests an LDAP configuration
     * @param {Object} opts Optional parameters
     * @param {module:model/GluuLdapConfiguration} opts.gluuLdapConfiguration GluuLdapConfiguration object
     * @param {module:api/DatabaseLDAPConfigurationApi~postConfigDatabaseLdapTestCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Boolean}
     */
  }, {
    key: "postConfigDatabaseLdapTest",
    value: function postConfigDatabaseLdapTest(opts, callback) {
      opts = opts || {};
      var postBody = opts['gluuLdapConfiguration'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = 'Boolean';
      return this.apiClient.callApi('/api/v1/config/database/ldap/test', 'POST', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }

    /**
     * Callback function to receive the result of the putConfigDatabaseLdap operation.
     * @callback module:api/DatabaseLDAPConfigurationApi~putConfigDatabaseLdapCallback
     * @param {String} error Error message, if any.
     * @param {module:model/GluuLdapConfiguration} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates LDAP configuration
     * Updates LDAP configuration
     * @param {Object} opts Optional parameters
     * @param {module:model/GluuLdapConfiguration} opts.gluuLdapConfiguration GluuLdapConfiguration object
     * @param {module:api/DatabaseLDAPConfigurationApi~putConfigDatabaseLdapCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/GluuLdapConfiguration}
     */
  }, {
    key: "putConfigDatabaseLdap",
    value: function putConfigDatabaseLdap(opts, callback) {
      opts = opts || {};
      var postBody = opts['gluuLdapConfiguration'];
      var pathParams = {};
      var queryParams = {};
      var headerParams = {};
      var formParams = {};
      var authNames = ['oauth2'];
      var contentTypes = ['application/json'];
      var accepts = ['application/json'];
      var returnType = _GluuLdapConfiguration["default"];
      return this.apiClient.callApi('/api/v1/config/database/ldap', 'PUT', pathParams, queryParams, headerParams, formParams, postBody, authNames, contentTypes, accepts, returnType, null, callback);
    }
  }]);
}();