import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["labelKey", "newSelectionPrefix", "options", "paginationText", "renderMenuItemChildren", "text"];
import PropTypes from 'prop-types';
import React from 'react';
import Highlighter from '../Highlighter';
import Menu from '../Menu';
import MenuItem from '../MenuItem';
import { getOptionLabel, getOptionProperty, isString } from '../../utils';
var propTypes = {
  /**
   * Provides the ability to specify a prefix before the user-entered text to
   * indicate that the selection will be new. No-op unless `allowNew={true}`.
   */
  newSelectionPrefix: PropTypes.node,
  /**
   * Prompt displayed when large data sets are paginated.
   */
  paginationText: PropTypes.node,
  /**
   * Provides a hook for customized rendering of menu item contents.
   */
  renderMenuItemChildren: PropTypes.func
};
function renderMenuItemChildrenFn(option, props) {
  return /*#__PURE__*/React.createElement(Highlighter, {
    search: props.text
  }, getOptionLabel(option, props.labelKey));
}
var TypeaheadMenu = function TypeaheadMenu(props) {
  var labelKey = props.labelKey,
    _props$newSelectionPr = props.newSelectionPrefix,
    newSelectionPrefix = _props$newSelectionPr === void 0 ? 'New selection: ' : _props$newSelectionPr,
    options = props.options,
    _props$paginationText = props.paginationText,
    paginationText = _props$paginationText === void 0 ? 'Display additional results...' : _props$paginationText,
    _props$renderMenuItem = props.renderMenuItemChildren,
    renderMenuItemChildren = _props$renderMenuItem === void 0 ? renderMenuItemChildrenFn : _props$renderMenuItem,
    text = props.text,
    menuProps = _objectWithoutProperties(props, _excluded);
  var renderMenuItem = function renderMenuItem(option, position) {
    var label = getOptionLabel(option, labelKey);
    var menuItemProps = {
      disabled: !!getOptionProperty(option, 'disabled'),
      label: label,
      option: option,
      position: position
    };
    if (getOptionProperty(option, 'customOption')) {
      return /*#__PURE__*/React.createElement(MenuItem, _extends({}, menuItemProps, {
        className: "rbt-menu-custom-option",
        key: position,
        label: label
      }), newSelectionPrefix, /*#__PURE__*/React.createElement(Highlighter, {
        search: text
      }, label));
    }
    if (getOptionProperty(option, 'paginationOption')) {
      return /*#__PURE__*/React.createElement(React.Fragment, {
        key: "pagination-option-divider"
      }, /*#__PURE__*/React.createElement(Menu.Divider, null), /*#__PURE__*/React.createElement(MenuItem, _extends({}, menuItemProps, {
        className: "rbt-menu-pagination-option",
        label:
        // TODO: Fix how (aria-)labels are passed to `MenuItem`.
        // `paginationText` can be a ReactNode.
        isString(paginationText) ? paginationText : ''
      }), paginationText));
    }
    return /*#__PURE__*/React.createElement(MenuItem, _extends({}, menuItemProps, {
      key: position
    }), renderMenuItemChildren(option, props, position));
  };
  return /*#__PURE__*/React.createElement(Menu, _extends({}, menuProps, {
    key:
    // Force a re-render if the text changes to ensure that menu
    // positioning updates correctly.
    text
  }), options.map(renderMenuItem));
};
TypeaheadMenu.propTypes = propTypes;
export default TypeaheadMenu;