"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = getUpdatedActiveIndex;
exports.isDisabledOption = isDisabledOption;
exports.skipDisabledOptions = skipDisabledOptions;
var _getOptionProperty = _interopRequireDefault(require("./getOptionProperty"));
function isDisabledOption(index, items) {
  var option = items[index];
  return !!option && !!(0, _getOptionProperty["default"])(option, 'disabled');
}
function skipDisabledOptions(currentIndex, key, items) {
  var newIndex = currentIndex;
  while (isDisabledOption(newIndex, items)) {
    newIndex += key === 'ArrowUp' ? -1 : 1;
  }
  return newIndex;
}
function getUpdatedActiveIndex(currentIndex, key, items) {
  var newIndex = currentIndex;

  // Increment or decrement index based on user keystroke.
  newIndex += key === 'ArrowUp' ? -1 : 1;

  // Skip over any disabled options.
  newIndex = skipDisabledOptions(newIndex, key, items);

  // If we've reached the end, go back to the beginning or vice-versa.
  if (newIndex === items.length) {
    newIndex = -1;
  } else if (newIndex === -2) {
    newIndex = items.length - 1;

    // Skip over any disabled options.
    newIndex = skipDisabledOptions(newIndex, key, items);
  }
  return newIndex;
}