# Installation
> `npm install --save @types/react-toggle`

# Summary
This package contains type definitions for react-toggle (https://github.com/aaronshaf/react-toggle).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-toggle.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-toggle/index.d.ts)
````ts
import { Component, InputHTMLAttributes, ReactNode } from "react";

export interface ToggleIcons {
    checked?: ReactNode | undefined;
    unchecked?: ReactNode | undefined;
}

export interface ToggleProps extends InputHTMLAttributes<HTMLInputElement> {
    "aria-labelledby"?: string | undefined;
    "aria-label"?: string | undefined;
    icons?: boolean | ToggleIcons | undefined;
}

export default class Toggle extends Component<ToggleProps> {}

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 20:08:00 GMT
 * Dependencies: [@types/react](https://npmjs.com/package/@types/react)

# Credits
These definitions were written by [Karol Janyst](https://github.com/LKay).
