import PropTypes from 'prop-types';
import React, { ReactNode } from 'react';
import { MenuProps } from '../Menu';
import { LabelKey, Option } from '../../types';
export type RenderMenuItemChildren = (option: Option, menuProps: TypeaheadMenuProps, idx: number) => JSX.Element;
export interface TypeaheadMenuProps extends MenuProps {
    labelKey: LabelKey;
    newSelectionPrefix?: ReactNode;
    options: Option[];
    paginationText?: ReactNode;
    renderMenuItemChildren?: RenderMenuItemChildren;
    text: string;
}
declare const TypeaheadMenu: {
    (props: TypeaheadMenuProps): React.JSX.Element;
    propTypes: {
        newSelectionPrefix: PropTypes.Requireable<PropTypes.ReactNodeLike>;
        paginationText: PropTypes.Requireable<PropTypes.ReactNodeLike>;
        renderMenuItemChildren: PropTypes.Requireable<(...args: any[]) => any>;
    };
};
export default TypeaheadMenu;
