"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;
var _getOptionLabel = _interopRequireDefault(require("./getOptionLabel"));
var _nodash = require("./nodash");
function addCustomOption(results, props) {
  var allowNew = props.allowNew,
    labelKey = props.labelKey,
    text = props.text;
  if (!allowNew || !text.trim()) {
    return false;
  }

  // If the consumer has provided a callback, use that to determine whether or
  // not to add the custom option.
  if ((0, _nodash.isFunction)(allowNew)) {
    return allowNew(results, props);
  }

  // By default, don't add the custom option if there is an exact text match
  // with an existing option.
  return !results.some(function (o) {
    return (0, _getOptionLabel["default"])(o, labelKey) === text;
  });
}
var _default = exports["default"] = addCustomOption;