import isEqual from 'fast-deep-equal';
import getOptionProperty from './getOptionProperty';
import { isFunction, isString } from './nodash';
import stripDiacritics from './stripDiacritics';
import warn from './warn';
function isMatch(input, string, props) {
    let searchStr = input;
    let str = string;
    if (!props.caseSensitive) {
        searchStr = searchStr.toLowerCase();
        str = str.toLowerCase();
    }
    if (props.ignoreDiacritics) {
        searchStr = stripDiacritics(searchStr);
        str = stripDiacritics(str);
    }
    return str.indexOf(searchStr) !== -1;
}
export default function defaultFilterBy(option, props) {
    const { filterBy, labelKey, multiple, selected, text } = props;
    if (multiple && selected.some((o) => isEqual(o, option))) {
        return false;
    }
    if (isFunction(labelKey)) {
        return isMatch(text, labelKey(option), props);
    }
    const fields = filterBy.slice();
    if (isString(labelKey)) {
        if (fields.indexOf(labelKey) === -1) {
            fields.unshift(labelKey);
        }
    }
    if (isString(option)) {
        warn(fields.length <= 1, 'You cannot filter by properties when `option` is a string.');
        return isMatch(text, option, props);
    }
    return fields.some((field) => {
        let value = getOptionProperty(option, field);
        if (!isString(value)) {
            warn(false, 'Fields passed to `filterBy` should have string values. Value will ' +
                'be converted to a string; results may be unexpected.');
            value = String(value);
        }
        return isMatch(text, value, props);
    });
}
