/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The SamlAppConfiguration model module.
 * @module model/SamlAppConfiguration
 * @version OAS Version
 */
class SamlAppConfiguration {
    /**
     * Constructs a new <code>SamlAppConfiguration</code>.
     * @alias module:model/SamlAppConfiguration
     */
    constructor() { 
        
        SamlAppConfiguration.initialize(this);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj) { 
    }

    /**
     * Constructs a <code>SamlAppConfiguration</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/SamlAppConfiguration} obj Optional instance to populate.
     * @return {module:model/SamlAppConfiguration} The populated <code>SamlAppConfiguration</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new SamlAppConfiguration();

            if (data.hasOwnProperty('applicationName')) {
                obj['applicationName'] = ApiClient.convertToType(data['applicationName'], 'String');
            }
            if (data.hasOwnProperty('samlTrustRelationshipDn')) {
                obj['samlTrustRelationshipDn'] = ApiClient.convertToType(data['samlTrustRelationshipDn'], 'String');
            }
            if (data.hasOwnProperty('trustedIdpDn')) {
                obj['trustedIdpDn'] = ApiClient.convertToType(data['trustedIdpDn'], 'String');
            }
            if (data.hasOwnProperty('enabled')) {
                obj['enabled'] = ApiClient.convertToType(data['enabled'], 'Boolean');
            }
            if (data.hasOwnProperty('selectedIdp')) {
                obj['selectedIdp'] = ApiClient.convertToType(data['selectedIdp'], 'String');
            }
            if (data.hasOwnProperty('serverUrl')) {
                obj['serverUrl'] = ApiClient.convertToType(data['serverUrl'], 'String');
            }
            if (data.hasOwnProperty('realm')) {
                obj['realm'] = ApiClient.convertToType(data['realm'], 'String');
            }
            if (data.hasOwnProperty('clientId')) {
                obj['clientId'] = ApiClient.convertToType(data['clientId'], 'String');
            }
            if (data.hasOwnProperty('clientSecret')) {
                obj['clientSecret'] = ApiClient.convertToType(data['clientSecret'], 'String');
            }
            if (data.hasOwnProperty('grantType')) {
                obj['grantType'] = ApiClient.convertToType(data['grantType'], 'String');
            }
            if (data.hasOwnProperty('scope')) {
                obj['scope'] = ApiClient.convertToType(data['scope'], 'String');
            }
            if (data.hasOwnProperty('username')) {
                obj['username'] = ApiClient.convertToType(data['username'], 'String');
            }
            if (data.hasOwnProperty('password')) {
                obj['password'] = ApiClient.convertToType(data['password'], 'String');
            }
            if (data.hasOwnProperty('spMetadataUrl')) {
                obj['spMetadataUrl'] = ApiClient.convertToType(data['spMetadataUrl'], 'String');
            }
            if (data.hasOwnProperty('tokenUrl')) {
                obj['tokenUrl'] = ApiClient.convertToType(data['tokenUrl'], 'String');
            }
            if (data.hasOwnProperty('idpUrl')) {
                obj['idpUrl'] = ApiClient.convertToType(data['idpUrl'], 'String');
            }
            if (data.hasOwnProperty('extIDPTokenUrl')) {
                obj['extIDPTokenUrl'] = ApiClient.convertToType(data['extIDPTokenUrl'], 'String');
            }
            if (data.hasOwnProperty('extIDPRedirectUrl')) {
                obj['extIDPRedirectUrl'] = ApiClient.convertToType(data['extIDPRedirectUrl'], 'String');
            }
            if (data.hasOwnProperty('idpMetadataImportUrl')) {
                obj['idpMetadataImportUrl'] = ApiClient.convertToType(data['idpMetadataImportUrl'], 'String');
            }
            if (data.hasOwnProperty('idpRootDir')) {
                obj['idpRootDir'] = ApiClient.convertToType(data['idpRootDir'], 'String');
            }
            if (data.hasOwnProperty('idpMetadataDir')) {
                obj['idpMetadataDir'] = ApiClient.convertToType(data['idpMetadataDir'], 'String');
            }
            if (data.hasOwnProperty('idpMetadataTempDir')) {
                obj['idpMetadataTempDir'] = ApiClient.convertToType(data['idpMetadataTempDir'], 'String');
            }
            if (data.hasOwnProperty('idpMetadataFile')) {
                obj['idpMetadataFile'] = ApiClient.convertToType(data['idpMetadataFile'], 'String');
            }
            if (data.hasOwnProperty('spMetadataDir')) {
                obj['spMetadataDir'] = ApiClient.convertToType(data['spMetadataDir'], 'String');
            }
            if (data.hasOwnProperty('spMetadataTempDir')) {
                obj['spMetadataTempDir'] = ApiClient.convertToType(data['spMetadataTempDir'], 'String');
            }
            if (data.hasOwnProperty('spMetadataFile')) {
                obj['spMetadataFile'] = ApiClient.convertToType(data['spMetadataFile'], 'String');
            }
            if (data.hasOwnProperty('ignoreValidation')) {
                obj['ignoreValidation'] = ApiClient.convertToType(data['ignoreValidation'], 'Boolean');
            }
            if (data.hasOwnProperty('setConfigDefaultValue')) {
                obj['setConfigDefaultValue'] = ApiClient.convertToType(data['setConfigDefaultValue'], 'Boolean');
            }
            if (data.hasOwnProperty('idpMetadataMandatoryAttributes')) {
                obj['idpMetadataMandatoryAttributes'] = ApiClient.convertToType(data['idpMetadataMandatoryAttributes'], ['String']);
            }
            if (data.hasOwnProperty('kcAttributes')) {
                obj['kcAttributes'] = ApiClient.convertToType(data['kcAttributes'], ['String']);
            }
            if (data.hasOwnProperty('kcSamlConfig')) {
                obj['kcSamlConfig'] = ApiClient.convertToType(data['kcSamlConfig'], ['String']);
            }
        }
        return obj;
    }


}

/**
 * Name of application.
 * @member {String} applicationName
 */
SamlAppConfiguration.prototype['applicationName'] = undefined;

/**
 * Trust relationship organizational unit.
 * @member {String} samlTrustRelationshipDn
 */
SamlAppConfiguration.prototype['samlTrustRelationshipDn'] = undefined;

/**
 * Identity provider organizational unit.
 * @member {String} trustedIdpDn
 */
SamlAppConfiguration.prototype['trustedIdpDn'] = undefined;

/**
 * SAML functionality enabled.
 * @member {Boolean} enabled
 */
SamlAppConfiguration.prototype['enabled'] = undefined;

/**
 * Selected SAML server.
 * @member {String} selectedIdp
 */
SamlAppConfiguration.prototype['selectedIdp'] = undefined;

/**
 * SAML server URL.
 * @member {String} serverUrl
 */
SamlAppConfiguration.prototype['serverUrl'] = undefined;

/**
 * SAML server realm, default is `jans`.
 * @member {String} realm
 */
SamlAppConfiguration.prototype['realm'] = undefined;

/**
 * Jans auth SAML client ID.
 * @member {String} clientId
 */
SamlAppConfiguration.prototype['clientId'] = undefined;

/**
 * Jans auth SAML client password.
 * @member {String} clientSecret
 */
SamlAppConfiguration.prototype['clientSecret'] = undefined;

/**
 * Grant type to get access token.
 * @member {String} grantType
 */
SamlAppConfiguration.prototype['grantType'] = undefined;

/**
 * Oauth2 scope to get access token.
 * @member {String} scope
 */
SamlAppConfiguration.prototype['scope'] = undefined;

/**
 * SAML server username.
 * @member {String} username
 */
SamlAppConfiguration.prototype['username'] = undefined;

/**
 * SAML server user credentails.
 * @member {String} password
 */
SamlAppConfiguration.prototype['password'] = undefined;

/**
 * Relative SAML server SP Metadata Url.
 * @member {String} spMetadataUrl
 */
SamlAppConfiguration.prototype['spMetadataUrl'] = undefined;

/**
 * Relative SAML server Token Url.
 * @member {String} tokenUrl
 */
SamlAppConfiguration.prototype['tokenUrl'] = undefined;

/**
 * Relative SAML server IDP Url.
 * @member {String} idpUrl
 */
SamlAppConfiguration.prototype['idpUrl'] = undefined;

/**
 * Relative SAML server IDP Token Url.
 * @member {String} extIDPTokenUrl
 */
SamlAppConfiguration.prototype['extIDPTokenUrl'] = undefined;

/**
 * Relative IDP redirect Url.
 * @member {String} extIDPRedirectUrl
 */
SamlAppConfiguration.prototype['extIDPRedirectUrl'] = undefined;

/**
 * Relative SAML server Metadata import Url.
 * @member {String} idpMetadataImportUrl
 */
SamlAppConfiguration.prototype['idpMetadataImportUrl'] = undefined;

/**
 * Jans Auth server root SAML directory.
 * @member {String} idpRootDir
 */
SamlAppConfiguration.prototype['idpRootDir'] = undefined;

/**
 * Jans Auth server relative SAML directory to store IDP Metadata files.
 * @member {String} idpMetadataDir
 */
SamlAppConfiguration.prototype['idpMetadataDir'] = undefined;

/**
 * Jans Auth server relative SAML temp directory to store IDP Metadata files.
 * @member {String} idpMetadataTempDir
 */
SamlAppConfiguration.prototype['idpMetadataTempDir'] = undefined;

/**
 * IDP Metadata file name format.
 * @member {String} idpMetadataFile
 */
SamlAppConfiguration.prototype['idpMetadataFile'] = undefined;

/**
 * Jans Auth server relative SAML directory to store SP Metadata files.
 * @member {String} spMetadataDir
 */
SamlAppConfiguration.prototype['spMetadataDir'] = undefined;

/**
 * Jans Auth server relative SAML temp directory to store SP Metadata files.
 * @member {String} spMetadataTempDir
 */
SamlAppConfiguration.prototype['spMetadataTempDir'] = undefined;

/**
 * SP Metadata file name format.
 * @member {String} spMetadataFile
 */
SamlAppConfiguration.prototype['spMetadataFile'] = undefined;

/**
 * Boolean value to enable/disable SAML validation.
 * @member {Boolean} ignoreValidation
 */
SamlAppConfiguration.prototype['ignoreValidation'] = undefined;

/**
 * Boolean value `true` to set the default values for an IDP.
 * @member {Boolean} setConfigDefaultValue
 */
SamlAppConfiguration.prototype['setConfigDefaultValue'] = undefined;

/**
 * List of mandatory IDP Metadata attributes.
 * @member {Array.<String>} idpMetadataMandatoryAttributes
 */
SamlAppConfiguration.prototype['idpMetadataMandatoryAttributes'] = undefined;

/**
 * Keycloak SAML attribute names.
 * @member {Array.<String>} kcAttributes
 */
SamlAppConfiguration.prototype['kcAttributes'] = undefined;

/**
 * Keycloak SAML config attribute names.
 * @member {Array.<String>} kcSamlConfig
 */
SamlAppConfiguration.prototype['kcSamlConfig'] = undefined;






export default SamlAppConfiguration;

