/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */

import ApiClient from '../ApiClient';

/**
 * The IdentityProvider model module.
 * @module model/IdentityProvider
 * @version OAS Version
 */
class IdentityProvider {
    /**
     * Constructs a new <code>IdentityProvider</code>.
     * @alias module:model/IdentityProvider
     * @param creatorId {String} Creator of IDP.
     * @param name {String} Name uniquely identifies an identity provider.
     * @param displayName {String} Identity provider display name.
     * @param description {String} Description of Identity provider.
     * @param realm {String} Realm in which Identity provider is created.
     */
    constructor(creatorId, name, displayName, description, realm) { 
        
        IdentityProvider.initialize(this, creatorId, name, displayName, description, realm);
    }

    /**
     * Initializes the fields of this object.
     * This method is used by the constructors of any subclasses, in order to implement multiple inheritance (mix-ins).
     * Only for internal use.
     */
    static initialize(obj, creatorId, name, displayName, description, realm) { 
        obj['creatorId'] = creatorId;
        obj['name'] = name;
        obj['displayName'] = displayName;
        obj['description'] = description;
        obj['realm'] = realm;
    }

    /**
     * Constructs a <code>IdentityProvider</code> from a plain JavaScript object, optionally creating a new instance.
     * Copies all relevant properties from <code>data</code> to <code>obj</code> if supplied or a new instance if not.
     * @param {Object} data The plain JavaScript object bearing properties of interest.
     * @param {module:model/IdentityProvider} obj Optional instance to populate.
     * @return {module:model/IdentityProvider} The populated <code>IdentityProvider</code> instance.
     */
    static constructFromObject(data, obj) {
        if (data) {
            obj = obj || new IdentityProvider();

            if (data.hasOwnProperty('dn')) {
                obj['dn'] = ApiClient.convertToType(data['dn'], 'String');
            }
            if (data.hasOwnProperty('inum')) {
                obj['inum'] = ApiClient.convertToType(data['inum'], 'String');
            }
            if (data.hasOwnProperty('creatorId')) {
                obj['creatorId'] = ApiClient.convertToType(data['creatorId'], 'String');
            }
            if (data.hasOwnProperty('name')) {
                obj['name'] = ApiClient.convertToType(data['name'], 'String');
            }
            if (data.hasOwnProperty('displayName')) {
                obj['displayName'] = ApiClient.convertToType(data['displayName'], 'String');
            }
            if (data.hasOwnProperty('description')) {
                obj['description'] = ApiClient.convertToType(data['description'], 'String');
            }
            if (data.hasOwnProperty('realm')) {
                obj['realm'] = ApiClient.convertToType(data['realm'], 'String');
            }
            if (data.hasOwnProperty('enabled')) {
                obj['enabled'] = ApiClient.convertToType(data['enabled'], 'Boolean');
            }
            if (data.hasOwnProperty('signingCertificate')) {
                obj['signingCertificate'] = ApiClient.convertToType(data['signingCertificate'], 'String');
            }
            if (data.hasOwnProperty('validateSignature')) {
                obj['validateSignature'] = ApiClient.convertToType(data['validateSignature'], 'String');
            }
            if (data.hasOwnProperty('singleLogoutServiceUrl')) {
                obj['singleLogoutServiceUrl'] = ApiClient.convertToType(data['singleLogoutServiceUrl'], 'String');
            }
            if (data.hasOwnProperty('nameIDPolicyFormat')) {
                obj['nameIDPolicyFormat'] = ApiClient.convertToType(data['nameIDPolicyFormat'], 'String');
            }
            if (data.hasOwnProperty('principalAttribute')) {
                obj['principalAttribute'] = ApiClient.convertToType(data['principalAttribute'], 'String');
            }
            if (data.hasOwnProperty('principalType')) {
                obj['principalType'] = ApiClient.convertToType(data['principalType'], 'String');
            }
            if (data.hasOwnProperty('idpEntityId')) {
                obj['idpEntityId'] = ApiClient.convertToType(data['idpEntityId'], 'String');
            }
            if (data.hasOwnProperty('singleSignOnServiceUrl')) {
                obj['singleSignOnServiceUrl'] = ApiClient.convertToType(data['singleSignOnServiceUrl'], 'String');
            }
            if (data.hasOwnProperty('encryptionPublicKey')) {
                obj['encryptionPublicKey'] = ApiClient.convertToType(data['encryptionPublicKey'], 'String');
            }
            if (data.hasOwnProperty('providerId')) {
                obj['providerId'] = ApiClient.convertToType(data['providerId'], 'String');
            }
            if (data.hasOwnProperty('trustEmail')) {
                obj['trustEmail'] = ApiClient.convertToType(data['trustEmail'], 'Boolean');
            }
            if (data.hasOwnProperty('storeToken')) {
                obj['storeToken'] = ApiClient.convertToType(data['storeToken'], 'Boolean');
            }
            if (data.hasOwnProperty('addReadTokenRoleOnCreate')) {
                obj['addReadTokenRoleOnCreate'] = ApiClient.convertToType(data['addReadTokenRoleOnCreate'], 'Boolean');
            }
            if (data.hasOwnProperty('authenticateByDefault')) {
                obj['authenticateByDefault'] = ApiClient.convertToType(data['authenticateByDefault'], 'Boolean');
            }
            if (data.hasOwnProperty('linkOnly')) {
                obj['linkOnly'] = ApiClient.convertToType(data['linkOnly'], 'Boolean');
            }
            if (data.hasOwnProperty('firstBrokerLoginFlowAlias')) {
                obj['firstBrokerLoginFlowAlias'] = ApiClient.convertToType(data['firstBrokerLoginFlowAlias'], 'String');
            }
            if (data.hasOwnProperty('postBrokerLoginFlowAlias')) {
                obj['postBrokerLoginFlowAlias'] = ApiClient.convertToType(data['postBrokerLoginFlowAlias'], 'String');
            }
            if (data.hasOwnProperty('spMetaDataURL')) {
                obj['spMetaDataURL'] = ApiClient.convertToType(data['spMetaDataURL'], 'String');
            }
            if (data.hasOwnProperty('spMetaDataLocation')) {
                obj['spMetaDataLocation'] = ApiClient.convertToType(data['spMetaDataLocation'], 'String');
            }
            if (data.hasOwnProperty('idpMetaDataURL')) {
                obj['idpMetaDataURL'] = ApiClient.convertToType(data['idpMetaDataURL'], 'String');
            }
            if (data.hasOwnProperty('idpMetaDataLocation')) {
                obj['idpMetaDataLocation'] = ApiClient.convertToType(data['idpMetaDataLocation'], 'String');
            }
            if (data.hasOwnProperty('status')) {
                obj['status'] = ApiClient.convertToType(data['status'], 'String');
            }
            if (data.hasOwnProperty('validationStatus')) {
                obj['validationStatus'] = ApiClient.convertToType(data['validationStatus'], 'String');
            }
            if (data.hasOwnProperty('validationLog')) {
                obj['validationLog'] = ApiClient.convertToType(data['validationLog'], ['String']);
            }
            if (data.hasOwnProperty('baseDn')) {
                obj['baseDn'] = ApiClient.convertToType(data['baseDn'], 'String');
            }
        }
        return obj;
    }


}

/**
 * @member {String} dn
 */
IdentityProvider.prototype['dn'] = undefined;

/**
 * Unique identifier.
 * @member {String} inum
 */
IdentityProvider.prototype['inum'] = undefined;

/**
 * Creator of IDP.
 * @member {String} creatorId
 */
IdentityProvider.prototype['creatorId'] = undefined;

/**
 * Name uniquely identifies an identity provider.
 * @member {String} name
 */
IdentityProvider.prototype['name'] = undefined;

/**
 * Identity provider display name.
 * @member {String} displayName
 */
IdentityProvider.prototype['displayName'] = undefined;

/**
 * Description of Identity provider.
 * @member {String} description
 */
IdentityProvider.prototype['description'] = undefined;

/**
 * Realm in which Identity provider is created.
 * @member {String} realm
 */
IdentityProvider.prototype['realm'] = undefined;

/**
 * Indicates if Identity provider is enabled.
 * @member {Boolean} enabled
 */
IdentityProvider.prototype['enabled'] = undefined;

/**
 * Digital certificate used to verify the authenticity of the request.
 * @member {String} signingCertificate
 */
IdentityProvider.prototype['signingCertificate'] = undefined;

/**
 * @member {String} validateSignature
 */
IdentityProvider.prototype['validateSignature'] = undefined;

/**
 * Url used to send logout requests.
 * @member {String} singleLogoutServiceUrl
 */
IdentityProvider.prototype['singleLogoutServiceUrl'] = undefined;

/**
 *  URI reference corresponding to a name identifier format.
 * @member {String} nameIDPolicyFormat
 */
IdentityProvider.prototype['nameIDPolicyFormat'] = undefined;

/**
 *  Name or Friendly Name of the attribute used to identify external users.
 * @member {String} principalAttribute
 */
IdentityProvider.prototype['principalAttribute'] = undefined;

/**
 * Way to identify and track external users from the assertion.
 * @member {String} principalType
 */
IdentityProvider.prototype['principalType'] = undefined;

/**
 * Entity ID that will be used to uniquely identify this SAML Service Provider.
 * @member {String} idpEntityId
 */
IdentityProvider.prototype['idpEntityId'] = undefined;

/**
 * Url used to send SAML authentication requests.
 * @member {String} singleSignOnServiceUrl
 */
IdentityProvider.prototype['singleSignOnServiceUrl'] = undefined;

/**
 * Public key to use to encrypt the message.
 * @member {String} encryptionPublicKey
 */
IdentityProvider.prototype['encryptionPublicKey'] = undefined;

/**
 * IDP provider, should be SAML.
 * @member {String} providerId
 */
IdentityProvider.prototype['providerId'] = undefined;

/**
 * If enabled, email provided by this provider is not verified even if verification is enabled for the realm.
 * @member {Boolean} trustEmail
 */
IdentityProvider.prototype['trustEmail'] = undefined;

/**
 * Enable/disable if tokens must be stored after authenticating users.
 * @member {Boolean} storeToken
 */
IdentityProvider.prototype['storeToken'] = undefined;

/**
 * Enable/disable if new users can read any stored tokens.
 * @member {Boolean} addReadTokenRoleOnCreate
 */
IdentityProvider.prototype['addReadTokenRoleOnCreate'] = undefined;

/**
 * @member {Boolean} authenticateByDefault
 */
IdentityProvider.prototype['authenticateByDefault'] = undefined;

/**
 * If true, users cannot log in through this provider. They can only link to this provider.
 * @member {Boolean} linkOnly
 */
IdentityProvider.prototype['linkOnly'] = undefined;

/**
 * Alias of authentication flow, which is triggered after first login with this identity provider. Term 'First Login' means that no Keycloak account is currently linked to the authenticated identity provider account.
 * @member {String} firstBrokerLoginFlowAlias
 */
IdentityProvider.prototype['firstBrokerLoginFlowAlias'] = undefined;

/**
 * Alias of authentication flow, which is triggered after each login with this identity provider.
 * @member {String} postBrokerLoginFlowAlias
 */
IdentityProvider.prototype['postBrokerLoginFlowAlias'] = undefined;

/**
 * SAML SP metadata file URL.
 * @member {String} spMetaDataURL
 */
IdentityProvider.prototype['spMetaDataURL'] = undefined;

/**
 * SP metadata file location.
 * @member {String} spMetaDataLocation
 */
IdentityProvider.prototype['spMetaDataLocation'] = undefined;

/**
 * SAML IDP metadata file URL.
 * @member {String} idpMetaDataURL
 */
IdentityProvider.prototype['idpMetaDataURL'] = undefined;

/**
 * SAML IDP metadata file location.
 * @member {String} idpMetaDataLocation
 */
IdentityProvider.prototype['idpMetaDataLocation'] = undefined;

/**
 * IDP setup status.
 * @member {module:model/IdentityProvider.StatusEnum} status
 */
IdentityProvider.prototype['status'] = undefined;

/**
 * IDP validation status.
 * @member {module:model/IdentityProvider.ValidationStatusEnum} validationStatus
 */
IdentityProvider.prototype['validationStatus'] = undefined;

/**
 * IDP validation log.
 * @member {Array.<String>} validationLog
 */
IdentityProvider.prototype['validationLog'] = undefined;

/**
 * @member {String} baseDn
 */
IdentityProvider.prototype['baseDn'] = undefined;





/**
 * Allowed values for the <code>status</code> property.
 * @enum {String}
 * @readonly
 */
IdentityProvider['StatusEnum'] = {

    /**
     * value: "active"
     * @const
     */
    "active": "active",

    /**
     * value: "inactive"
     * @const
     */
    "inactive": "inactive",

    /**
     * value: "expired"
     * @const
     */
    "expired": "expired",

    /**
     * value: "register"
     * @const
     */
    "register": "register"
};


/**
 * Allowed values for the <code>validationStatus</code> property.
 * @enum {String}
 * @readonly
 */
IdentityProvider['ValidationStatusEnum'] = {

    /**
     * value: "In Progress"
     * @const
     */
    "In Progress": "In Progress",

    /**
     * value: "Success"
     * @const
     */
    "Success": "Success",

    /**
     * value: "Scheduled"
     * @const
     */
    "Scheduled": "Scheduled",

    /**
     * value: "Failed"
     * @const
     */
    "Failed": "Failed"
};



export default IdentityProvider;

