/**
 * Jans Config API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: OAS Version
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 *
 */


import ApiClient from "../ApiClient";
import PagedResult from '../model/PagedResult';
import UmaResource from '../model/UmaResource';

/**
* OAuthUMAResources service.
* @module api/OAuthUMAResourcesApi
* @version OAS Version
*/
export default class OAuthUMAResourcesApi {

    /**
    * Constructs a new OAuthUMAResourcesApi. 
    * @alias module:api/OAuthUMAResourcesApi
    * @class
    * @param {module:ApiClient} [apiClient] Optional API client implementation to use,
    * default to {@link module:ApiClient#instance} if unspecified.
    */
    constructor(apiClient) {
        this.apiClient = apiClient || ApiClient.instance;
    }


    /**
     * Callback function to receive the result of the deleteOauthUmaResourcesById operation.
     * @callback module:api/OAuthUMAResourcesApi~deleteOauthUmaResourcesByIdCallback
     * @param {String} error Error message, if any.
     * @param data This operation does not return a value.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Deletes an UMA resource
     * Deletes an UMA resource
     * @param {String} id Resource description ID
     * @param {module:api/OAuthUMAResourcesApi~deleteOauthUmaResourcesByIdCallback} callback The callback function, accepting three arguments: error, data, response
     */
    deleteOauthUmaResourcesById(id, callback) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling deleteOauthUmaResourcesById");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = [];
      let returnType = null;
      return this.apiClient.callApi(
        '/api/v1/uma/resources/{id}', 'DELETE',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getOauthUmaResources operation.
     * @callback module:api/OAuthUMAResourcesApi~getOauthUmaResourcesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/PagedResult} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets list of UMA resources
     * Gets list of UMA resources
     * @param {Object} opts Optional parameters
     * @param {Number} opts.limit Search size - max size of the results to return (default to 50)
     * @param {String} opts.pattern Search pattern (default to '')
     * @param {Number} opts.startIndex The 1-based index of the first query result (default to 0)
     * @param {String} opts.sortBy Attribute whose value will be used to order the returned response (default to 'inum')
     * @param {String} opts.sortOrder Order in which the sortBy param is applied. Allowed values are \"ascending\" and \"descending\" (default to 'ascending')
     * @param {String} opts.fieldValuePair Field and value pair for seraching (default to '')
     * @param {module:api/OAuthUMAResourcesApi~getOauthUmaResourcesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/PagedResult}
     */
    getOauthUmaResources(opts, callback) {
      opts = opts || {};
      let postBody = null;

      let pathParams = {
      };
      let queryParams = {
        'limit': opts['limit'],
        'pattern': opts['pattern'],
        'startIndex': opts['startIndex'],
        'sortBy': opts['sortBy'],
        'sortOrder': opts['sortOrder'],
        'fieldValuePair': opts['fieldValuePair']
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = PagedResult;
      return this.apiClient.callApi(
        '/api/v1/uma/resources', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getOauthUmaResourcesByClientid operation.
     * @callback module:api/OAuthUMAResourcesApi~getOauthUmaResourcesByClientidCallback
     * @param {String} error Error message, if any.
     * @param {Array.<module:model/UmaResource>} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Fetch uma resources by client id
     * Fetch uma resources by client id
     * @param {String} clientId Client ID
     * @param {module:api/OAuthUMAResourcesApi~getOauthUmaResourcesByClientidCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link Array.<module:model/UmaResource>}
     */
    getOauthUmaResourcesByClientid(clientId, callback) {
      let postBody = null;
      // verify the required parameter 'clientId' is set
      if (clientId === undefined || clientId === null) {
        throw new Error("Missing the required parameter 'clientId' when calling getOauthUmaResourcesByClientid");
      }

      let pathParams = {
        'clientId': clientId
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = [UmaResource];
      return this.apiClient.callApi(
        '/api/v1/uma/resources/clientId/{clientId}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the getOauthUmaResourcesById operation.
     * @callback module:api/OAuthUMAResourcesApi~getOauthUmaResourcesByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UmaResource} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Gets an UMA resource by ID
     * Gets an UMA resource by ID
     * @param {String} id Resource description ID
     * @param {module:api/OAuthUMAResourcesApi~getOauthUmaResourcesByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UmaResource}
     */
    getOauthUmaResourcesById(id, callback) {
      let postBody = null;
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling getOauthUmaResourcesById");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = [];
      let accepts = ['application/json'];
      let returnType = UmaResource;
      return this.apiClient.callApi(
        '/api/v1/uma/resources/{id}', 'GET',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the patchOauthUmaResourcesById operation.
     * @callback module:api/OAuthUMAResourcesApi~patchOauthUmaResourcesByIdCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UmaResource} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Patch UMA resource
     * Patch UMA resource
     * @param {String} id Resource description ID
     * @param {Object} opts Optional parameters
     * @param {Array.<Object>} opts.requestBody String representing patch-document.
     * @param {module:api/OAuthUMAResourcesApi~patchOauthUmaResourcesByIdCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UmaResource}
     */
    patchOauthUmaResourcesById(id, opts, callback) {
      opts = opts || {};
      let postBody = opts['requestBody'];
      // verify the required parameter 'id' is set
      if (id === undefined || id === null) {
        throw new Error("Missing the required parameter 'id' when calling patchOauthUmaResourcesById");
      }

      let pathParams = {
        'id': id
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json-patch+json'];
      let accepts = ['application/json'];
      let returnType = UmaResource;
      return this.apiClient.callApi(
        '/api/v1/uma/resources/{id}', 'PATCH',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the postOauthUmaResources operation.
     * @callback module:api/OAuthUMAResourcesApi~postOauthUmaResourcesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UmaResource} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Creates an UMA resource
     * Creates an UMA resource
     * @param {Object} opts Optional parameters
     * @param {module:model/UmaResource} opts.umaResource UmaResource object
     * @param {module:api/OAuthUMAResourcesApi~postOauthUmaResourcesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UmaResource}
     */
    postOauthUmaResources(opts, callback) {
      opts = opts || {};
      let postBody = opts['umaResource'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = UmaResource;
      return this.apiClient.callApi(
        '/api/v1/uma/resources', 'POST',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }

    /**
     * Callback function to receive the result of the putOauthUmaResources operation.
     * @callback module:api/OAuthUMAResourcesApi~putOauthUmaResourcesCallback
     * @param {String} error Error message, if any.
     * @param {module:model/UmaResource} data The data returned by the service call.
     * @param {String} response The complete HTTP response.
     */

    /**
     * Updates an UMA resource
     * Updates an UMA resource
     * @param {Object} opts Optional parameters
     * @param {module:model/UmaResource} opts.umaResource UmaResource object
     * @param {module:api/OAuthUMAResourcesApi~putOauthUmaResourcesCallback} callback The callback function, accepting three arguments: error, data, response
     * data is of type: {@link module:model/UmaResource}
     */
    putOauthUmaResources(opts, callback) {
      opts = opts || {};
      let postBody = opts['umaResource'];

      let pathParams = {
      };
      let queryParams = {
      };
      let headerParams = {
      };
      let formParams = {
      };

      let authNames = ['oauth2'];
      let contentTypes = ['application/json'];
      let accepts = ['application/json'];
      let returnType = UmaResource;
      return this.apiClient.callApi(
        '/api/v1/uma/resources', 'PUT',
        pathParams, queryParams, headerParams, formParams, postBody,
        authNames, contentTypes, accepts, returnType, null, callback
      );
    }


}
